package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "compromisedRate", 
    "events"})
@JsonInclude(Include.NON_NULL)
public class SimulationEventsContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("compromisedRate")
    protected Double compromisedRate;

    @JsonProperty("events")
    protected List<SimulationEvent> events;

    @JsonProperty("events@nextLink")
    protected String eventsNextLink;

    protected SimulationEventsContent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulationEventsContent";
    }

    @Property(name="compromisedRate")
    @JsonIgnore
    public Optional<Double> getCompromisedRate() {
        return Optional.ofNullable(compromisedRate);
    }

    public SimulationEventsContent withCompromisedRate(Double compromisedRate) {
        SimulationEventsContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationEventsContent");
        _x.compromisedRate = compromisedRate;
        return _x;
    }

    @Property(name="events")
    @JsonIgnore
    public CollectionPage<SimulationEvent> getEvents() {
        return new CollectionPage<SimulationEvent>(contextPath, SimulationEvent.class, this.events, Optional.ofNullable(eventsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="events")
    @JsonIgnore
    public CollectionPage<SimulationEvent> getEvents(HttpRequestOptions options) {
        return new CollectionPage<SimulationEvent>(contextPath, SimulationEvent.class, this.events, Optional.ofNullable(eventsNextLink), Collections.emptyList(), options);
    }

    public SimulationEventsContent withUnmappedField(String name, Object value) {
        SimulationEventsContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double compromisedRate;
        private List<SimulationEvent> events;
        private String eventsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder compromisedRate(Double compromisedRate) {
            this.compromisedRate = compromisedRate;
            this.changedFields = changedFields.add("compromisedRate");
            return this;
        }

        public Builder events(List<SimulationEvent> events) {
            this.events = events;
            this.changedFields = changedFields.add("events");
            return this;
        }

        public Builder events(SimulationEvent... events) {
            return events(Arrays.asList(events));
        }

        public Builder eventsNextLink(String eventsNextLink) {
            this.eventsNextLink = eventsNextLink;
            this.changedFields = changedFields.add("events");
            return this;
        }

        public SimulationEventsContent build() {
            SimulationEventsContent _x = new SimulationEventsContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulationEventsContent";
            _x.compromisedRate = compromisedRate;
            _x.events = events;
            _x.eventsNextLink = eventsNextLink;
            return _x;
        }
    }

    private SimulationEventsContent _copy() {
        SimulationEventsContent _x = new SimulationEventsContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.compromisedRate = compromisedRate;
        _x.events = events;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SimulationEventsContent[");
        b.append("compromisedRate=");
        b.append(this.compromisedRate);
        b.append(", ");
        b.append("events=");
        b.append(this.events);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
