package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "count", 
    "eventName"})
@JsonInclude(Include.NON_NULL)
public class SimulationEvent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("count")
    protected Integer count;

    @JsonProperty("eventName")
    protected String eventName;

    protected SimulationEvent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.simulationEvent";
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public SimulationEvent withCount(Integer count) {
        SimulationEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationEvent");
        _x.count = count;
        return _x;
    }

    @Property(name="eventName")
    @JsonIgnore
    public Optional<String> getEventName() {
        return Optional.ofNullable(eventName);
    }

    public SimulationEvent withEventName(String eventName) {
        SimulationEvent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.simulationEvent");
        _x.eventName = eventName;
        return _x;
    }

    public SimulationEvent withUnmappedField(String name, Object value) {
        SimulationEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer count;
        private String eventName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            this.changedFields = changedFields.add("eventName");
            return this;
        }

        public SimulationEvent build() {
            SimulationEvent _x = new SimulationEvent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.simulationEvent";
            _x.count = count;
            _x.eventName = eventName;
            return _x;
        }
    }

    private SimulationEvent _copy() {
        SimulationEvent _x = new SimulationEvent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.count = count;
        _x.eventName = eventName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SimulationEvent[");
        b.append("count=");
        b.append(this.count);
        b.append(", ");
        b.append("eventName=");
        b.append(this.eventName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
