package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "signature", 
    "signingKeyId"})
@JsonInclude(Include.NON_NULL)
public class SigningResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("signature")
    protected byte[] signature;

    @JsonProperty("signingKeyId")
    protected String signingKeyId;

    protected SigningResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signingResult";
    }

    @Property(name="signature")
    @JsonIgnore
    public Optional<byte[]> getSignature() {
        return Optional.ofNullable(signature);
    }

    public SigningResult withSignature(byte[] signature) {
        SigningResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signingResult");
        _x.signature = signature;
        return _x;
    }

    @Property(name="signingKeyId")
    @JsonIgnore
    public Optional<String> getSigningKeyId() {
        return Optional.ofNullable(signingKeyId);
    }

    public SigningResult withSigningKeyId(String signingKeyId) {
        SigningResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signingResult");
        _x.signingKeyId = signingKeyId;
        return _x;
    }

    public SigningResult withUnmappedField(String name, Object value) {
        SigningResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] signature;
        private String signingKeyId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder signature(byte[] signature) {
            this.signature = signature;
            this.changedFields = changedFields.add("signature");
            return this;
        }

        public Builder signingKeyId(String signingKeyId) {
            this.signingKeyId = signingKeyId;
            this.changedFields = changedFields.add("signingKeyId");
            return this;
        }

        public SigningResult build() {
            SigningResult _x = new SigningResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.signingResult";
            _x.signature = signature;
            _x.signingKeyId = signingKeyId;
            return _x;
        }
    }

    private SigningResult _copy() {
        SigningResult _x = new SigningResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.signature = signature;
        _x.signingKeyId = signingKeyId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SigningResult[");
        b.append("signature=");
        b.append(this.signature);
        b.append(", ");
        b.append("signingKeyId=");
        b.append(this.signingKeyId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
