package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SigninFrequencyType;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class SignInFrequencySessionControl extends ConditionalAccessSessionControl implements ODataType {

    @JsonProperty("type")
    protected SigninFrequencyType type;

    @JsonProperty("value")
    protected Integer value;

    protected SignInFrequencySessionControl() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signInFrequencySessionControl";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<SigninFrequencyType> getType() {
        return Optional.ofNullable(type);
    }

    public SignInFrequencySessionControl withType(SigninFrequencyType type) {
        SignInFrequencySessionControl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInFrequencySessionControl");
        _x.type = type;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<Integer> getValue() {
        return Optional.ofNullable(value);
    }

    public SignInFrequencySessionControl withValue(Integer value) {
        SignInFrequencySessionControl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInFrequencySessionControl");
        _x.value = value;
        return _x;
    }

    public SignInFrequencySessionControl withUnmappedField(String name, Object value) {
        SignInFrequencySessionControl _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSignInFrequencySessionControl() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnabled;
        private SigninFrequencyType type;
        private Integer value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder type(SigninFrequencyType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public SignInFrequencySessionControl build() {
            SignInFrequencySessionControl _x = new SignInFrequencySessionControl();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.signInFrequencySessionControl";
            _x.isEnabled = isEnabled;
            _x.type = type;
            _x.value = value;
            return _x;
        }
    }

    private SignInFrequencySessionControl _copy() {
        SignInFrequencySessionControl _x = new SignInFrequencySessionControl();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isEnabled = isEnabled;
        _x.type = type;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SignInFrequencySessionControl[");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
