package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "recurrence", 
    "timeSlots", 
    "timeZone"})
@JsonInclude(Include.NON_NULL)
public class ShiftAvailability implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("timeSlots")
    protected List<TimeRange> timeSlots;

    @JsonProperty("timeSlots@nextLink")
    protected String timeSlotsNextLink;

    @JsonProperty("timeZone")
    protected String timeZone;

    protected ShiftAvailability() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.shiftAvailability";
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public ShiftAvailability withRecurrence(PatternedRecurrence recurrence) {
        ShiftAvailability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shiftAvailability");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="timeSlots")
    @JsonIgnore
    public CollectionPage<TimeRange> getTimeSlots() {
        return new CollectionPage<TimeRange>(contextPath, TimeRange.class, this.timeSlots, Optional.ofNullable(timeSlotsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="timeSlots")
    @JsonIgnore
    public CollectionPage<TimeRange> getTimeSlots(HttpRequestOptions options) {
        return new CollectionPage<TimeRange>(contextPath, TimeRange.class, this.timeSlots, Optional.ofNullable(timeSlotsNextLink), Collections.emptyList(), options);
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public ShiftAvailability withTimeZone(String timeZone) {
        ShiftAvailability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shiftAvailability");
        _x.timeZone = timeZone;
        return _x;
    }

    public ShiftAvailability withUnmappedField(String name, Object value) {
        ShiftAvailability _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PatternedRecurrence recurrence;
        private List<TimeRange> timeSlots;
        private String timeSlotsNextLink;
        private String timeZone;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder timeSlots(List<TimeRange> timeSlots) {
            this.timeSlots = timeSlots;
            this.changedFields = changedFields.add("timeSlots");
            return this;
        }

        public Builder timeSlots(TimeRange... timeSlots) {
            return timeSlots(Arrays.asList(timeSlots));
        }

        public Builder timeSlotsNextLink(String timeSlotsNextLink) {
            this.timeSlotsNextLink = timeSlotsNextLink;
            this.changedFields = changedFields.add("timeSlots");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public ShiftAvailability build() {
            ShiftAvailability _x = new ShiftAvailability();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.shiftAvailability";
            _x.recurrence = recurrence;
            _x.timeSlots = timeSlots;
            _x.timeSlotsNextLink = timeSlotsNextLink;
            _x.timeZone = timeZone;
            return _x;
        }
    }

    private ShiftAvailability _copy() {
        ShiftAvailability _x = new ShiftAvailability();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.recurrence = recurrence;
        _x.timeSlots = timeSlots;
        _x.timeZone = timeZone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ShiftAvailability[");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("timeSlots=");
        b.append(this.timeSlots);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
