package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "group", 
    "siteGroup", 
    "siteUser"})
@JsonInclude(Include.NON_NULL)
public class SharePointIdentitySet extends IdentitySet implements ODataType {

    @JsonProperty("group")
    protected Identity group;

    @JsonProperty("siteGroup")
    protected SharePointIdentity siteGroup;

    @JsonProperty("siteUser")
    protected SharePointIdentity siteUser;

    protected SharePointIdentitySet() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharePointIdentitySet";
    }

    @Property(name="group")
    @JsonIgnore
    public Optional<Identity> getGroup() {
        return Optional.ofNullable(group);
    }

    public SharePointIdentitySet withGroup(Identity group) {
        SharePointIdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointIdentitySet");
        _x.group = group;
        return _x;
    }

    @Property(name="siteGroup")
    @JsonIgnore
    public Optional<SharePointIdentity> getSiteGroup() {
        return Optional.ofNullable(siteGroup);
    }

    public SharePointIdentitySet withSiteGroup(SharePointIdentity siteGroup) {
        SharePointIdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointIdentitySet");
        _x.siteGroup = siteGroup;
        return _x;
    }

    @Property(name="siteUser")
    @JsonIgnore
    public Optional<SharePointIdentity> getSiteUser() {
        return Optional.ofNullable(siteUser);
    }

    public SharePointIdentitySet withSiteUser(SharePointIdentity siteUser) {
        SharePointIdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointIdentitySet");
        _x.siteUser = siteUser;
        return _x;
    }

    public SharePointIdentitySet withUnmappedField(String name, Object value) {
        SharePointIdentitySet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharePointIdentitySet() {
        return new Builder();
    }

    public static final class Builder {
        private Identity application;
        private Identity device;
        private Identity user;
        private Identity group;
        private SharePointIdentity siteGroup;
        private SharePointIdentity siteUser;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder application(Identity application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder device(Identity device) {
            this.device = device;
            this.changedFields = changedFields.add("device");
            return this;
        }

        public Builder user(Identity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public Builder group(Identity group) {
            this.group = group;
            this.changedFields = changedFields.add("group");
            return this;
        }

        public Builder siteGroup(SharePointIdentity siteGroup) {
            this.siteGroup = siteGroup;
            this.changedFields = changedFields.add("siteGroup");
            return this;
        }

        public Builder siteUser(SharePointIdentity siteUser) {
            this.siteUser = siteUser;
            this.changedFields = changedFields.add("siteUser");
            return this;
        }

        public SharePointIdentitySet build() {
            SharePointIdentitySet _x = new SharePointIdentitySet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sharePointIdentitySet";
            _x.application = application;
            _x.device = device;
            _x.user = user;
            _x.group = group;
            _x.siteGroup = siteGroup;
            _x.siteUser = siteUser;
            return _x;
        }
    }

    private SharePointIdentitySet _copy() {
        SharePointIdentitySet _x = new SharePointIdentitySet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.application = application;
        _x.device = device;
        _x.user = user;
        _x.group = group;
        _x.siteGroup = siteGroup;
        _x.siteUser = siteUser;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharePointIdentitySet[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("device=");
        b.append(this.device);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append(", ");
        b.append("group=");
        b.append(this.group);
        b.append(", ");
        b.append("siteGroup=");
        b.append(this.siteGroup);
        b.append(", ");
        b.append("siteUser=");
        b.append(this.siteUser);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
