package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isArchived", 
    "isFavorited", 
    "isRead"})
@JsonInclude(Include.NON_NULL)
public class ServiceUpdateMessageViewpoint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isArchived")
    protected Boolean isArchived;

    @JsonProperty("isFavorited")
    protected Boolean isFavorited;

    @JsonProperty("isRead")
    protected Boolean isRead;

    protected ServiceUpdateMessageViewpoint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceUpdateMessageViewpoint";
    }

    @Property(name="isArchived")
    @JsonIgnore
    public Optional<Boolean> getIsArchived() {
        return Optional.ofNullable(isArchived);
    }

    public ServiceUpdateMessageViewpoint withIsArchived(Boolean isArchived) {
        ServiceUpdateMessageViewpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessageViewpoint");
        _x.isArchived = isArchived;
        return _x;
    }

    @Property(name="isFavorited")
    @JsonIgnore
    public Optional<Boolean> getIsFavorited() {
        return Optional.ofNullable(isFavorited);
    }

    public ServiceUpdateMessageViewpoint withIsFavorited(Boolean isFavorited) {
        ServiceUpdateMessageViewpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessageViewpoint");
        _x.isFavorited = isFavorited;
        return _x;
    }

    @Property(name="isRead")
    @JsonIgnore
    public Optional<Boolean> getIsRead() {
        return Optional.ofNullable(isRead);
    }

    public ServiceUpdateMessageViewpoint withIsRead(Boolean isRead) {
        ServiceUpdateMessageViewpoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.serviceUpdateMessageViewpoint");
        _x.isRead = isRead;
        return _x;
    }

    public ServiceUpdateMessageViewpoint withUnmappedField(String name, Object value) {
        ServiceUpdateMessageViewpoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isArchived;
        private Boolean isFavorited;
        private Boolean isRead;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            this.changedFields = changedFields.add("isArchived");
            return this;
        }

        public Builder isFavorited(Boolean isFavorited) {
            this.isFavorited = isFavorited;
            this.changedFields = changedFields.add("isFavorited");
            return this;
        }

        public Builder isRead(Boolean isRead) {
            this.isRead = isRead;
            this.changedFields = changedFields.add("isRead");
            return this;
        }

        public ServiceUpdateMessageViewpoint build() {
            ServiceUpdateMessageViewpoint _x = new ServiceUpdateMessageViewpoint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceUpdateMessageViewpoint";
            _x.isArchived = isArchived;
            _x.isFavorited = isFavorited;
            _x.isRead = isRead;
            return _x;
        }
    }

    private ServiceUpdateMessageViewpoint _copy() {
        ServiceUpdateMessageViewpoint _x = new ServiceUpdateMessageViewpoint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isArchived = isArchived;
        _x.isFavorited = isFavorited;
        _x.isRead = isRead;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceUpdateMessageViewpoint[");
        b.append("isArchived=");
        b.append(this.isArchived);
        b.append(", ");
        b.append("isFavorited=");
        b.append(this.isFavorited);
        b.append(", ");
        b.append("isRead=");
        b.append(this.isRead);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
