package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "preFetchMedia"})
@JsonInclude(Include.NON_NULL)
public class ServiceHostedMediaConfig extends MediaConfig implements ODataType {

    @JsonProperty("preFetchMedia")
    protected List<MediaInfo> preFetchMedia;

    @JsonProperty("preFetchMedia@nextLink")
    protected String preFetchMediaNextLink;

    protected ServiceHostedMediaConfig() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.serviceHostedMediaConfig";
    }

    @Property(name="preFetchMedia")
    @JsonIgnore
    public CollectionPage<MediaInfo> getPreFetchMedia() {
        return new CollectionPage<MediaInfo>(contextPath, MediaInfo.class, this.preFetchMedia, Optional.ofNullable(preFetchMediaNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="preFetchMedia")
    @JsonIgnore
    public CollectionPage<MediaInfo> getPreFetchMedia(HttpRequestOptions options) {
        return new CollectionPage<MediaInfo>(contextPath, MediaInfo.class, this.preFetchMedia, Optional.ofNullable(preFetchMediaNextLink), Collections.emptyList(), options);
    }

    public ServiceHostedMediaConfig withUnmappedField(String name, Object value) {
        ServiceHostedMediaConfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceHostedMediaConfig() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean removeFromDefaultAudioGroup;
        private List<MediaInfo> preFetchMedia;
        private String preFetchMediaNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder removeFromDefaultAudioGroup(Boolean removeFromDefaultAudioGroup) {
            this.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
            this.changedFields = changedFields.add("removeFromDefaultAudioGroup");
            return this;
        }

        public Builder preFetchMedia(List<MediaInfo> preFetchMedia) {
            this.preFetchMedia = preFetchMedia;
            this.changedFields = changedFields.add("preFetchMedia");
            return this;
        }

        public Builder preFetchMedia(MediaInfo... preFetchMedia) {
            return preFetchMedia(Arrays.asList(preFetchMedia));
        }

        public Builder preFetchMediaNextLink(String preFetchMediaNextLink) {
            this.preFetchMediaNextLink = preFetchMediaNextLink;
            this.changedFields = changedFields.add("preFetchMedia");
            return this;
        }

        public ServiceHostedMediaConfig build() {
            ServiceHostedMediaConfig _x = new ServiceHostedMediaConfig();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.serviceHostedMediaConfig";
            _x.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
            _x.preFetchMedia = preFetchMedia;
            _x.preFetchMediaNextLink = preFetchMediaNextLink;
            return _x;
        }
    }

    private ServiceHostedMediaConfig _copy() {
        ServiceHostedMediaConfig _x = new ServiceHostedMediaConfig();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
        _x.preFetchMedia = preFetchMedia;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceHostedMediaConfig[");
        b.append("removeFromDefaultAudioGroup=");
        b.append(this.removeFromDefaultAudioGroup);
        b.append(", ");
        b.append("preFetchMedia=");
        b.append(this.preFetchMedia);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
