package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "confidence", 
    "evidences", 
    "idMatch", 
    "length", 
    "offset"})
@JsonInclude(Include.NON_NULL)
public class SensitiveContentLocation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("evidences")
    protected List<SensitiveContentEvidence> evidences;

    @JsonProperty("evidences@nextLink")
    protected String evidencesNextLink;

    @JsonProperty("idMatch")
    protected String idMatch;

    @JsonProperty("length")
    protected Integer length;

    @JsonProperty("offset")
    protected Integer offset;

    protected SensitiveContentLocation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sensitiveContentLocation";
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public SensitiveContentLocation withConfidence(Integer confidence) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="evidences")
    @JsonIgnore
    public CollectionPage<SensitiveContentEvidence> getEvidences() {
        return new CollectionPage<SensitiveContentEvidence>(contextPath, SensitiveContentEvidence.class, this.evidences, Optional.ofNullable(evidencesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="evidences")
    @JsonIgnore
    public CollectionPage<SensitiveContentEvidence> getEvidences(HttpRequestOptions options) {
        return new CollectionPage<SensitiveContentEvidence>(contextPath, SensitiveContentEvidence.class, this.evidences, Optional.ofNullable(evidencesNextLink), Collections.emptyList(), options);
    }

    @Property(name="idMatch")
    @JsonIgnore
    public Optional<String> getIdMatch() {
        return Optional.ofNullable(idMatch);
    }

    public SensitiveContentLocation withIdMatch(String idMatch) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.idMatch = idMatch;
        return _x;
    }

    @Property(name="length")
    @JsonIgnore
    public Optional<Integer> getLength() {
        return Optional.ofNullable(length);
    }

    public SensitiveContentLocation withLength(Integer length) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.length = length;
        return _x;
    }

    @Property(name="offset")
    @JsonIgnore
    public Optional<Integer> getOffset() {
        return Optional.ofNullable(offset);
    }

    public SensitiveContentLocation withOffset(Integer offset) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.offset = offset;
        return _x;
    }

    public SensitiveContentLocation withUnmappedField(String name, Object value) {
        SensitiveContentLocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private List<SensitiveContentEvidence> evidences;
        private String evidencesNextLink;
        private String idMatch;
        private Integer length;
        private Integer offset;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder evidences(List<SensitiveContentEvidence> evidences) {
            this.evidences = evidences;
            this.changedFields = changedFields.add("evidences");
            return this;
        }

        public Builder evidences(SensitiveContentEvidence... evidences) {
            return evidences(Arrays.asList(evidences));
        }

        public Builder evidencesNextLink(String evidencesNextLink) {
            this.evidencesNextLink = evidencesNextLink;
            this.changedFields = changedFields.add("evidences");
            return this;
        }

        public Builder idMatch(String idMatch) {
            this.idMatch = idMatch;
            this.changedFields = changedFields.add("idMatch");
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            this.changedFields = changedFields.add("length");
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            this.changedFields = changedFields.add("offset");
            return this;
        }

        public SensitiveContentLocation build() {
            SensitiveContentLocation _x = new SensitiveContentLocation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.sensitiveContentLocation";
            _x.confidence = confidence;
            _x.evidences = evidences;
            _x.evidencesNextLink = evidencesNextLink;
            _x.idMatch = idMatch;
            _x.length = length;
            _x.offset = offset;
            return _x;
        }
    }

    private SensitiveContentLocation _copy() {
        SensitiveContentLocation _x = new SensitiveContentLocation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.evidences = evidences;
        _x.idMatch = idMatch;
        _x.length = length;
        _x.offset = offset;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SensitiveContentLocation[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("evidences=");
        b.append(this.evidences);
        b.append(", ");
        b.append("idMatch=");
        b.append(this.idMatch);
        b.append(", ");
        b.append("length=");
        b.append(this.length);
        b.append(", ");
        b.append("offset=");
        b.append(this.offset);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
