package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.OperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "status", 
    "updatedDateTime", 
    "user"})
@JsonInclude(Include.NON_NULL)
public class SecurityActionState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("status")
    protected OperationStatus status;

    @JsonProperty("updatedDateTime")
    protected OffsetDateTime updatedDateTime;

    @JsonProperty("user")
    protected String user;

    protected SecurityActionState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityActionState";
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public SecurityActionState withAppId(String appId) {
        SecurityActionState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityActionState");
        _x.appId = appId;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<OperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SecurityActionState withStatus(OperationStatus status) {
        SecurityActionState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityActionState");
        _x.status = status;
        return _x;
    }

    @Property(name="updatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUpdatedDateTime() {
        return Optional.ofNullable(updatedDateTime);
    }

    public SecurityActionState withUpdatedDateTime(OffsetDateTime updatedDateTime) {
        SecurityActionState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityActionState");
        _x.updatedDateTime = updatedDateTime;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<String> getUser() {
        return Optional.ofNullable(user);
    }

    public SecurityActionState withUser(String user) {
        SecurityActionState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityActionState");
        _x.user = user;
        return _x;
    }

    public SecurityActionState withUnmappedField(String name, Object value) {
        SecurityActionState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private OperationStatus status;
        private OffsetDateTime updatedDateTime;
        private String user;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder updatedDateTime(OffsetDateTime updatedDateTime) {
            this.updatedDateTime = updatedDateTime;
            this.changedFields = changedFields.add("updatedDateTime");
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public SecurityActionState build() {
            SecurityActionState _x = new SecurityActionState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.securityActionState";
            _x.appId = appId;
            _x.status = status;
            _x.updatedDateTime = updatedDateTime;
            _x.user = user;
            return _x;
        }
    }

    private SecurityActionState _copy() {
        SecurityActionState _x = new SecurityActionState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        _x.status = status;
        _x.updatedDateTime = updatedDateTime;
        _x.user = user;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityActionState[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("updatedDateTime=");
        b.append(this.updatedDateTime);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
