package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "hitsContainers", 
    "queryAlterationResponse", 
    "resultTemplates", 
    "searchTerms"})
@JsonInclude(Include.NON_NULL)
public class SearchResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hitsContainers")
    protected List<SearchHitsContainer> hitsContainers;

    @JsonProperty("hitsContainers@nextLink")
    protected String hitsContainersNextLink;

    @JsonProperty("queryAlterationResponse")
    protected AlterationResponse queryAlterationResponse;

    @JsonProperty("resultTemplates")
    protected ResultTemplateDictionary resultTemplates;

    @JsonProperty("searchTerms")
    protected List<String> searchTerms;

    @JsonProperty("searchTerms@nextLink")
    protected String searchTermsNextLink;

    protected SearchResponse() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchResponse";
    }

    @Property(name="hitsContainers")
    @JsonIgnore
    public CollectionPage<SearchHitsContainer> getHitsContainers() {
        return new CollectionPage<SearchHitsContainer>(contextPath, SearchHitsContainer.class, this.hitsContainers, Optional.ofNullable(hitsContainersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="hitsContainers")
    @JsonIgnore
    public CollectionPage<SearchHitsContainer> getHitsContainers(HttpRequestOptions options) {
        return new CollectionPage<SearchHitsContainer>(contextPath, SearchHitsContainer.class, this.hitsContainers, Optional.ofNullable(hitsContainersNextLink), Collections.emptyList(), options);
    }

    @Property(name="queryAlterationResponse")
    @JsonIgnore
    public Optional<AlterationResponse> getQueryAlterationResponse() {
        return Optional.ofNullable(queryAlterationResponse);
    }

    public SearchResponse withQueryAlterationResponse(AlterationResponse queryAlterationResponse) {
        SearchResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchResponse");
        _x.queryAlterationResponse = queryAlterationResponse;
        return _x;
    }

    @Property(name="resultTemplates")
    @JsonIgnore
    public Optional<ResultTemplateDictionary> getResultTemplates() {
        return Optional.ofNullable(resultTemplates);
    }

    public SearchResponse withResultTemplates(ResultTemplateDictionary resultTemplates) {
        SearchResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchResponse");
        _x.resultTemplates = resultTemplates;
        return _x;
    }

    @Property(name="searchTerms")
    @JsonIgnore
    public CollectionPage<String> getSearchTerms() {
        return new CollectionPage<String>(contextPath, String.class, this.searchTerms, Optional.ofNullable(searchTermsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="searchTerms")
    @JsonIgnore
    public CollectionPage<String> getSearchTerms(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.searchTerms, Optional.ofNullable(searchTermsNextLink), Collections.emptyList(), options);
    }

    public SearchResponse withUnmappedField(String name, Object value) {
        SearchResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SearchHitsContainer> hitsContainers;
        private String hitsContainersNextLink;
        private AlterationResponse queryAlterationResponse;
        private ResultTemplateDictionary resultTemplates;
        private List<String> searchTerms;
        private String searchTermsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder hitsContainers(List<SearchHitsContainer> hitsContainers) {
            this.hitsContainers = hitsContainers;
            this.changedFields = changedFields.add("hitsContainers");
            return this;
        }

        public Builder hitsContainers(SearchHitsContainer... hitsContainers) {
            return hitsContainers(Arrays.asList(hitsContainers));
        }

        public Builder hitsContainersNextLink(String hitsContainersNextLink) {
            this.hitsContainersNextLink = hitsContainersNextLink;
            this.changedFields = changedFields.add("hitsContainers");
            return this;
        }

        public Builder queryAlterationResponse(AlterationResponse queryAlterationResponse) {
            this.queryAlterationResponse = queryAlterationResponse;
            this.changedFields = changedFields.add("queryAlterationResponse");
            return this;
        }

        public Builder resultTemplates(ResultTemplateDictionary resultTemplates) {
            this.resultTemplates = resultTemplates;
            this.changedFields = changedFields.add("resultTemplates");
            return this;
        }

        public Builder searchTerms(List<String> searchTerms) {
            this.searchTerms = searchTerms;
            this.changedFields = changedFields.add("searchTerms");
            return this;
        }

        public Builder searchTerms(String... searchTerms) {
            return searchTerms(Arrays.asList(searchTerms));
        }

        public Builder searchTermsNextLink(String searchTermsNextLink) {
            this.searchTermsNextLink = searchTermsNextLink;
            this.changedFields = changedFields.add("searchTerms");
            return this;
        }

        public SearchResponse build() {
            SearchResponse _x = new SearchResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchResponse";
            _x.hitsContainers = hitsContainers;
            _x.hitsContainersNextLink = hitsContainersNextLink;
            _x.queryAlterationResponse = queryAlterationResponse;
            _x.resultTemplates = resultTemplates;
            _x.searchTerms = searchTerms;
            _x.searchTermsNextLink = searchTermsNextLink;
            return _x;
        }
    }

    private SearchResponse _copy() {
        SearchResponse _x = new SearchResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hitsContainers = hitsContainers;
        _x.queryAlterationResponse = queryAlterationResponse;
        _x.resultTemplates = resultTemplates;
        _x.searchTerms = searchTerms;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchResponse[");
        b.append("hitsContainers=");
        b.append(this.hitsContainers);
        b.append(", ");
        b.append("queryAlterationResponse=");
        b.append(this.queryAlterationResponse);
        b.append(", ");
        b.append("resultTemplates=");
        b.append(this.resultTemplates);
        b.append(", ");
        b.append("searchTerms=");
        b.append(this.searchTerms);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
