package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "contentSource", 
    "hitId", 
    "rank", 
    "resultTemplateId", 
    "summary", 
    "_id", 
    "_score", 
    "_summary", 
    "resource", 
    "_source"})
@JsonInclude(Include.NON_NULL)
public class SearchHit implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentSource")
    protected String contentSource;

    @JsonProperty("hitId")
    protected String hitId;

    @JsonProperty("rank")
    protected Integer rank;

    @JsonProperty("resultTemplateId")
    protected String resultTemplateId;

    @JsonProperty("summary")
    protected String summary;

    @JsonProperty("_id")
    protected String _id;

    @JsonProperty("_score")
    protected Integer _score;

    @JsonProperty("_summary")
    protected String _summary;

    @JsonProperty("resource")
    protected Entity resource;

    @JsonProperty("_source")
    protected Entity _source;

    protected SearchHit() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchHit";
    }

    @Property(name="contentSource")
    @JsonIgnore
    public Optional<String> getContentSource() {
        return Optional.ofNullable(contentSource);
    }

    public SearchHit withContentSource(String contentSource) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x.contentSource = contentSource;
        return _x;
    }

    @Property(name="hitId")
    @JsonIgnore
    public Optional<String> getHitId() {
        return Optional.ofNullable(hitId);
    }

    public SearchHit withHitId(String hitId) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x.hitId = hitId;
        return _x;
    }

    @Property(name="rank")
    @JsonIgnore
    public Optional<Integer> getRank() {
        return Optional.ofNullable(rank);
    }

    public SearchHit withRank(Integer rank) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x.rank = rank;
        return _x;
    }

    @Property(name="resultTemplateId")
    @JsonIgnore
    public Optional<String> getResultTemplateId() {
        return Optional.ofNullable(resultTemplateId);
    }

    public SearchHit withResultTemplateId(String resultTemplateId) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x.resultTemplateId = resultTemplateId;
        return _x;
    }

    @Property(name="summary")
    @JsonIgnore
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    public SearchHit withSummary(String summary) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x.summary = summary;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property _id
     */
    @Property(name="_id")
    @JsonIgnore
    public Optional<String> get_id() {
        return Optional.ofNullable(_id);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code _id} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param _id
     *            new value of {@code _id} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code _id} field changed
     */
    public SearchHit with_id(String _id) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._id = _id;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property _score
     */
    @Property(name="_score")
    @JsonIgnore
    public Optional<Integer> get_score() {
        return Optional.ofNullable(_score);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code _score} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param _score
     *            new value of {@code _score} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code _score} field changed
     */
    public SearchHit with_score(Integer _score) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._score = _score;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return property _summary
     */
    @Property(name="_summary")
    @JsonIgnore
    public Optional<String> get_summary() {
        return Optional.ofNullable(_summary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code _summary} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param _summary
     *            new value of {@code _summary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code _summary} field changed
     */
    public SearchHit with_summary(String _summary) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._summary = _summary;
        return _x;
    }

    public SearchHit withUnmappedField(String name, Object value) {
        SearchHit _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String contentSource;
        private String hitId;
        private Integer rank;
        private String resultTemplateId;
        private String summary;
        private String _id;
        private Integer _score;
        private String _summary;
        private Entity resource;
        private Entity _source;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contentSource(String contentSource) {
            this.contentSource = contentSource;
            this.changedFields = changedFields.add("contentSource");
            return this;
        }

        public Builder hitId(String hitId) {
            this.hitId = hitId;
            this.changedFields = changedFields.add("hitId");
            return this;
        }

        public Builder rank(Integer rank) {
            this.rank = rank;
            this.changedFields = changedFields.add("rank");
            return this;
        }

        public Builder resultTemplateId(String resultTemplateId) {
            this.resultTemplateId = resultTemplateId;
            this.changedFields = changedFields.add("resultTemplateId");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.changedFields = changedFields.add("summary");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param _id
         *            value of {@code _id} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder _id(String _id) {
            this._id = _id;
            this.changedFields = changedFields.add("_id");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param _score
         *            value of {@code _score} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder _score(Integer _score) {
            this._score = _score;
            this.changedFields = changedFields.add("_score");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param _summary
         *            value of {@code _summary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder _summary(String _summary) {
            this._summary = _summary;
            this.changedFields = changedFields.add("_summary");
            return this;
        }

        public Builder resource(Entity resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param _source
         *            value of {@code _source} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder _source(Entity _source) {
            this._source = _source;
            this.changedFields = changedFields.add("_source");
            return this;
        }

        public SearchHit build() {
            SearchHit _x = new SearchHit();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchHit";
            _x.contentSource = contentSource;
            _x.hitId = hitId;
            _x.rank = rank;
            _x.resultTemplateId = resultTemplateId;
            _x.summary = summary;
            _x._id = _id;
            _x._score = _score;
            _x._summary = _summary;
            _x.resource = resource;
            _x._source = _source;
            return _x;
        }
    }

    private SearchHit _copy() {
        SearchHit _x = new SearchHit();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contentSource = contentSource;
        _x.hitId = hitId;
        _x.rank = rank;
        _x.resultTemplateId = resultTemplateId;
        _x.summary = summary;
        _x._id = _id;
        _x._score = _score;
        _x._summary = _summary;
        _x.resource = resource;
        _x._source = _source;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchHit[");
        b.append("contentSource=");
        b.append(this.contentSource);
        b.append(", ");
        b.append("hitId=");
        b.append(this.hitId);
        b.append(", ");
        b.append("rank=");
        b.append(this.rank);
        b.append(", ");
        b.append("resultTemplateId=");
        b.append(this.resultTemplateId);
        b.append(", ");
        b.append("summary=");
        b.append(this.summary);
        b.append(", ");
        b.append("_id=");
        b.append(this._id);
        b.append(", ");
        b.append("_score=");
        b.append(this._score);
        b.append(", ");
        b.append("_summary=");
        b.append(this._summary);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("_source=");
        b.append(this._source);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
