package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "alteredHighlightedQueryString", 
    "alteredQueryString", 
    "alteredQueryTokens"})
@JsonInclude(Include.NON_NULL)
public class SearchAlteration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("alteredHighlightedQueryString")
    protected String alteredHighlightedQueryString;

    @JsonProperty("alteredQueryString")
    protected String alteredQueryString;

    @JsonProperty("alteredQueryTokens")
    protected List<AlteredQueryToken> alteredQueryTokens;

    @JsonProperty("alteredQueryTokens@nextLink")
    protected String alteredQueryTokensNextLink;

    protected SearchAlteration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchAlteration";
    }

    @Property(name="alteredHighlightedQueryString")
    @JsonIgnore
    public Optional<String> getAlteredHighlightedQueryString() {
        return Optional.ofNullable(alteredHighlightedQueryString);
    }

    public SearchAlteration withAlteredHighlightedQueryString(String alteredHighlightedQueryString) {
        SearchAlteration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchAlteration");
        _x.alteredHighlightedQueryString = alteredHighlightedQueryString;
        return _x;
    }

    @Property(name="alteredQueryString")
    @JsonIgnore
    public Optional<String> getAlteredQueryString() {
        return Optional.ofNullable(alteredQueryString);
    }

    public SearchAlteration withAlteredQueryString(String alteredQueryString) {
        SearchAlteration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchAlteration");
        _x.alteredQueryString = alteredQueryString;
        return _x;
    }

    @Property(name="alteredQueryTokens")
    @JsonIgnore
    public CollectionPage<AlteredQueryToken> getAlteredQueryTokens() {
        return new CollectionPage<AlteredQueryToken>(contextPath, AlteredQueryToken.class, this.alteredQueryTokens, Optional.ofNullable(alteredQueryTokensNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="alteredQueryTokens")
    @JsonIgnore
    public CollectionPage<AlteredQueryToken> getAlteredQueryTokens(HttpRequestOptions options) {
        return new CollectionPage<AlteredQueryToken>(contextPath, AlteredQueryToken.class, this.alteredQueryTokens, Optional.ofNullable(alteredQueryTokensNextLink), Collections.emptyList(), options);
    }

    public SearchAlteration withUnmappedField(String name, Object value) {
        SearchAlteration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String alteredHighlightedQueryString;
        private String alteredQueryString;
        private List<AlteredQueryToken> alteredQueryTokens;
        private String alteredQueryTokensNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder alteredHighlightedQueryString(String alteredHighlightedQueryString) {
            this.alteredHighlightedQueryString = alteredHighlightedQueryString;
            this.changedFields = changedFields.add("alteredHighlightedQueryString");
            return this;
        }

        public Builder alteredQueryString(String alteredQueryString) {
            this.alteredQueryString = alteredQueryString;
            this.changedFields = changedFields.add("alteredQueryString");
            return this;
        }

        public Builder alteredQueryTokens(List<AlteredQueryToken> alteredQueryTokens) {
            this.alteredQueryTokens = alteredQueryTokens;
            this.changedFields = changedFields.add("alteredQueryTokens");
            return this;
        }

        public Builder alteredQueryTokens(AlteredQueryToken... alteredQueryTokens) {
            return alteredQueryTokens(Arrays.asList(alteredQueryTokens));
        }

        public Builder alteredQueryTokensNextLink(String alteredQueryTokensNextLink) {
            this.alteredQueryTokensNextLink = alteredQueryTokensNextLink;
            this.changedFields = changedFields.add("alteredQueryTokens");
            return this;
        }

        public SearchAlteration build() {
            SearchAlteration _x = new SearchAlteration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchAlteration";
            _x.alteredHighlightedQueryString = alteredHighlightedQueryString;
            _x.alteredQueryString = alteredQueryString;
            _x.alteredQueryTokens = alteredQueryTokens;
            _x.alteredQueryTokensNextLink = alteredQueryTokensNextLink;
            return _x;
        }
    }

    private SearchAlteration _copy() {
        SearchAlteration _x = new SearchAlteration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.alteredHighlightedQueryString = alteredHighlightedQueryString;
        _x.alteredQueryString = alteredQueryString;
        _x.alteredQueryTokens = alteredQueryTokens;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchAlteration[");
        b.append("alteredHighlightedQueryString=");
        b.append(this.alteredHighlightedQueryString);
        b.append(", ");
        b.append("alteredQueryString=");
        b.append(this.alteredQueryString);
        b.append(", ");
        b.append("alteredQueryTokens=");
        b.append(this.alteredQueryTokens);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
