package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "buckets", 
    "field"})
@JsonInclude(Include.NON_NULL)
public class SearchAggregation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("buckets")
    protected List<SearchBucket> buckets;

    @JsonProperty("buckets@nextLink")
    protected String bucketsNextLink;

    @JsonProperty("field")
    protected String field;

    protected SearchAggregation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchAggregation";
    }

    @Property(name="buckets")
    @JsonIgnore
    public CollectionPage<SearchBucket> getBuckets() {
        return new CollectionPage<SearchBucket>(contextPath, SearchBucket.class, this.buckets, Optional.ofNullable(bucketsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="buckets")
    @JsonIgnore
    public CollectionPage<SearchBucket> getBuckets(HttpRequestOptions options) {
        return new CollectionPage<SearchBucket>(contextPath, SearchBucket.class, this.buckets, Optional.ofNullable(bucketsNextLink), Collections.emptyList(), options);
    }

    @Property(name="field")
    @JsonIgnore
    public Optional<String> getField() {
        return Optional.ofNullable(field);
    }

    public SearchAggregation withField(String field) {
        SearchAggregation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchAggregation");
        _x.field = field;
        return _x;
    }

    public SearchAggregation withUnmappedField(String name, Object value) {
        SearchAggregation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SearchBucket> buckets;
        private String bucketsNextLink;
        private String field;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder buckets(List<SearchBucket> buckets) {
            this.buckets = buckets;
            this.changedFields = changedFields.add("buckets");
            return this;
        }

        public Builder buckets(SearchBucket... buckets) {
            return buckets(Arrays.asList(buckets));
        }

        public Builder bucketsNextLink(String bucketsNextLink) {
            this.bucketsNextLink = bucketsNextLink;
            this.changedFields = changedFields.add("buckets");
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            this.changedFields = changedFields.add("field");
            return this;
        }

        public SearchAggregation build() {
            SearchAggregation _x = new SearchAggregation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.searchAggregation";
            _x.buckets = buckets;
            _x.bucketsNextLink = bucketsNextLink;
            _x.field = field;
            return _x;
        }
    }

    private SearchAggregation _copy() {
        SearchAggregation _x = new SearchAggregation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.buckets = buckets;
        _x.field = field;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchAggregation[");
        b.append("buckets=");
        b.append(this.buckets);
        b.append(", ");
        b.append("field=");
        b.append(this.field);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
