package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.FreeBusyStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "end", 
    "isPrivate", 
    "location", 
    "start", 
    "status", 
    "subject"})
@JsonInclude(Include.NON_NULL)
public class ScheduleItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("end")
    protected DateTimeTimeZone end;

    @JsonProperty("isPrivate")
    protected Boolean isPrivate;

    @JsonProperty("location")
    protected String location;

    @JsonProperty("start")
    protected DateTimeTimeZone start;

    @JsonProperty("status")
    protected FreeBusyStatus status;

    @JsonProperty("subject")
    protected String subject;

    protected ScheduleItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.scheduleItem";
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEnd() {
        return Optional.ofNullable(end);
    }

    public ScheduleItem withEnd(DateTimeTimeZone end) {
        ScheduleItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleItem");
        _x.end = end;
        return _x;
    }

    @Property(name="isPrivate")
    @JsonIgnore
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(isPrivate);
    }

    public ScheduleItem withIsPrivate(Boolean isPrivate) {
        ScheduleItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleItem");
        _x.isPrivate = isPrivate;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    public ScheduleItem withLocation(String location) {
        ScheduleItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleItem");
        _x.location = location;
        return _x;
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStart() {
        return Optional.ofNullable(start);
    }

    public ScheduleItem withStart(DateTimeTimeZone start) {
        ScheduleItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleItem");
        _x.start = start;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<FreeBusyStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ScheduleItem withStatus(FreeBusyStatus status) {
        ScheduleItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleItem");
        _x.status = status;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public ScheduleItem withSubject(String subject) {
        ScheduleItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleItem");
        _x.subject = subject;
        return _x;
    }

    public ScheduleItem withUnmappedField(String name, Object value) {
        ScheduleItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DateTimeTimeZone end;
        private Boolean isPrivate;
        private String location;
        private DateTimeTimeZone start;
        private FreeBusyStatus status;
        private String subject;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder end(DateTimeTimeZone end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = changedFields.add("isPrivate");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder start(DateTimeTimeZone start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public Builder status(FreeBusyStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public ScheduleItem build() {
            ScheduleItem _x = new ScheduleItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.scheduleItem";
            _x.end = end;
            _x.isPrivate = isPrivate;
            _x.location = location;
            _x.start = start;
            _x.status = status;
            _x.subject = subject;
            return _x;
        }
    }

    private ScheduleItem _copy() {
        ScheduleItem _x = new ScheduleItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.end = end;
        _x.isPrivate = isPrivate;
        _x.location = location;
        _x.start = start;
        _x.status = status;
        _x.subject = subject;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScheduleItem[");
        b.append("end=");
        b.append(this.end);
        b.append(", ");
        b.append("isPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("start=");
        b.append(this.start);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
