package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "columnId", 
    "qualityId"})
@JsonInclude(Include.NON_NULL)
public class RubricQualitySelectedColumnModel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("columnId")
    protected String columnId;

    @JsonProperty("qualityId")
    protected String qualityId;

    protected RubricQualitySelectedColumnModel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rubricQualitySelectedColumnModel";
    }

    @Property(name="columnId")
    @JsonIgnore
    public Optional<String> getColumnId() {
        return Optional.ofNullable(columnId);
    }

    public RubricQualitySelectedColumnModel withColumnId(String columnId) {
        RubricQualitySelectedColumnModel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQualitySelectedColumnModel");
        _x.columnId = columnId;
        return _x;
    }

    @Property(name="qualityId")
    @JsonIgnore
    public Optional<String> getQualityId() {
        return Optional.ofNullable(qualityId);
    }

    public RubricQualitySelectedColumnModel withQualityId(String qualityId) {
        RubricQualitySelectedColumnModel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQualitySelectedColumnModel");
        _x.qualityId = qualityId;
        return _x;
    }

    public RubricQualitySelectedColumnModel withUnmappedField(String name, Object value) {
        RubricQualitySelectedColumnModel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String columnId;
        private String qualityId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder columnId(String columnId) {
            this.columnId = columnId;
            this.changedFields = changedFields.add("columnId");
            return this;
        }

        public Builder qualityId(String qualityId) {
            this.qualityId = qualityId;
            this.changedFields = changedFields.add("qualityId");
            return this;
        }

        public RubricQualitySelectedColumnModel build() {
            RubricQualitySelectedColumnModel _x = new RubricQualitySelectedColumnModel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rubricQualitySelectedColumnModel";
            _x.columnId = columnId;
            _x.qualityId = qualityId;
            return _x;
        }
    }

    private RubricQualitySelectedColumnModel _copy() {
        RubricQualitySelectedColumnModel _x = new RubricQualitySelectedColumnModel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.columnId = columnId;
        _x.qualityId = qualityId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RubricQualitySelectedColumnModel[");
        b.append("columnId=");
        b.append(this.columnId);
        b.append(", ");
        b.append("qualityId=");
        b.append(this.qualityId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
