package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "feedback", 
    "qualityId"})
@JsonInclude(Include.NON_NULL)
public class RubricQualityFeedbackModel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("feedback")
    protected EducationItemBody feedback;

    @JsonProperty("qualityId")
    protected String qualityId;

    protected RubricQualityFeedbackModel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rubricQualityFeedbackModel";
    }

    @Property(name="feedback")
    @JsonIgnore
    public Optional<EducationItemBody> getFeedback() {
        return Optional.ofNullable(feedback);
    }

    public RubricQualityFeedbackModel withFeedback(EducationItemBody feedback) {
        RubricQualityFeedbackModel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQualityFeedbackModel");
        _x.feedback = feedback;
        return _x;
    }

    @Property(name="qualityId")
    @JsonIgnore
    public Optional<String> getQualityId() {
        return Optional.ofNullable(qualityId);
    }

    public RubricQualityFeedbackModel withQualityId(String qualityId) {
        RubricQualityFeedbackModel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rubricQualityFeedbackModel");
        _x.qualityId = qualityId;
        return _x;
    }

    public RubricQualityFeedbackModel withUnmappedField(String name, Object value) {
        RubricQualityFeedbackModel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EducationItemBody feedback;
        private String qualityId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder feedback(EducationItemBody feedback) {
            this.feedback = feedback;
            this.changedFields = changedFields.add("feedback");
            return this;
        }

        public Builder qualityId(String qualityId) {
            this.qualityId = qualityId;
            this.changedFields = changedFields.add("qualityId");
            return this;
        }

        public RubricQualityFeedbackModel build() {
            RubricQualityFeedbackModel _x = new RubricQualityFeedbackModel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rubricQualityFeedbackModel";
            _x.feedback = feedback;
            _x.qualityId = qualityId;
            return _x;
        }
    }

    private RubricQualityFeedbackModel _copy() {
        RubricQualityFeedbackModel _x = new RubricQualityFeedbackModel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.feedback = feedback;
        _x.qualityId = qualityId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RubricQualityFeedbackModel[");
        b.append("feedback=");
        b.append(this.feedback);
        b.append(", ");
        b.append("qualityId=");
        b.append(this.qualityId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
