package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.edm.UnsignedByte;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Color in RGB.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "b", 
    "g", 
    "r"})
@JsonInclude(Include.NON_NULL)
public class RgbColor implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("b")
    protected UnsignedByte b;

    @JsonProperty("g")
    protected UnsignedByte g;

    @JsonProperty("r")
    protected UnsignedByte r;

    protected RgbColor() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.rgbColor";
    }

    /**
     * <i>“Blue value”</i>
     * 
     * @return property b
     */
    @Property(name="b")
    @JsonIgnore
    public Optional<UnsignedByte> getB() {
        return Optional.ofNullable(b);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code b} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Blue value”</i>
     * 
     * @param b
     *            new value of {@code b} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code b} field changed
     */
    public RgbColor withB(UnsignedByte b) {
        RgbColor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rgbColor");
        _x.b = b;
        return _x;
    }

    /**
     * <i>“Green value”</i>
     * 
     * @return property g
     */
    @Property(name="g")
    @JsonIgnore
    public Optional<UnsignedByte> getG() {
        return Optional.ofNullable(g);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code g} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Green value”</i>
     * 
     * @param g
     *            new value of {@code g} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code g} field changed
     */
    public RgbColor withG(UnsignedByte g) {
        RgbColor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rgbColor");
        _x.g = g;
        return _x;
    }

    /**
     * <i>“Red value”</i>
     * 
     * @return property r
     */
    @Property(name="r")
    @JsonIgnore
    public Optional<UnsignedByte> getR() {
        return Optional.ofNullable(r);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code r} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Red value”</i>
     * 
     * @param r
     *            new value of {@code r} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code r} field changed
     */
    public RgbColor withR(UnsignedByte r) {
        RgbColor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.rgbColor");
        _x.r = r;
        return _x;
    }

    public RgbColor withUnmappedField(String name, Object value) {
        RgbColor _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UnsignedByte b;
        private UnsignedByte g;
        private UnsignedByte r;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Blue value”</i>
         * 
         * @param b
         *            value of {@code b} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder b(UnsignedByte b) {
            this.b = b;
            this.changedFields = changedFields.add("b");
            return this;
        }

        /**
         * <i>“Green value”</i>
         * 
         * @param g
         *            value of {@code g} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder g(UnsignedByte g) {
            this.g = g;
            this.changedFields = changedFields.add("g");
            return this;
        }

        /**
         * <i>“Red value”</i>
         * 
         * @param r
         *            value of {@code r} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder r(UnsignedByte r) {
            this.r = r;
            this.changedFields = changedFields.add("r");
            return this;
        }

        public RgbColor build() {
            RgbColor _x = new RgbColor();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.rgbColor";
            _x.b = b;
            _x.g = g;
            _x.r = r;
            return _x;
        }
    }

    private RgbColor _copy() {
        RgbColor _x = new RgbColor();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.b = b;
        _x.g = g;
        _x.r = r;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RgbColor[");
        b.append("b=");
        b.append(this.b);
        b.append(", ");
        b.append("g=");
        b.append(this.g);
        b.append(", ");
        b.append("r=");
        b.append(this.r);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
