package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ResponseType;

@JsonPropertyOrder({
    "@odata.type", 
    "response", 
    "time"})
@JsonInclude(Include.NON_NULL)
public class ResponseStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("response")
    protected ResponseType response;

    @JsonProperty("time")
    protected OffsetDateTime time;

    protected ResponseStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.responseStatus";
    }

    @Property(name="response")
    @JsonIgnore
    public Optional<ResponseType> getResponse() {
        return Optional.ofNullable(response);
    }

    public ResponseStatus withResponse(ResponseType response) {
        ResponseStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responseStatus");
        _x.response = response;
        return _x;
    }

    @Property(name="time")
    @JsonIgnore
    public Optional<OffsetDateTime> getTime() {
        return Optional.ofNullable(time);
    }

    public ResponseStatus withTime(OffsetDateTime time) {
        ResponseStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responseStatus");
        _x.time = time;
        return _x;
    }

    public ResponseStatus withUnmappedField(String name, Object value) {
        ResponseStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ResponseType response;
        private OffsetDateTime time;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder response(ResponseType response) {
            this.response = response;
            this.changedFields = changedFields.add("response");
            return this;
        }

        public Builder time(OffsetDateTime time) {
            this.time = time;
            this.changedFields = changedFields.add("time");
            return this;
        }

        public ResponseStatus build() {
            ResponseStatus _x = new ResponseStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.responseStatus";
            _x.response = response;
            _x.time = time;
            return _x;
        }
    }

    private ResponseStatus _copy() {
        ResponseStatus _x = new ResponseStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.response = response;
        _x.time = time;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResponseStatus[");
        b.append("response=");
        b.append(this.response);
        b.append(", ");
        b.append("time=");
        b.append(this.time);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
