package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "containerDisplayName", 
    "containerType", 
    "containerWebUrl", 
    "mediaType", 
    "previewImageUrl", 
    "previewText", 
    "title", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class ResourceVisualization implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("containerDisplayName")
    protected String containerDisplayName;

    @JsonProperty("containerType")
    protected String containerType;

    @JsonProperty("containerWebUrl")
    protected String containerWebUrl;

    @JsonProperty("mediaType")
    protected String mediaType;

    @JsonProperty("previewImageUrl")
    protected String previewImageUrl;

    @JsonProperty("previewText")
    protected String previewText;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("type")
    protected String type;

    protected ResourceVisualization() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.resourceVisualization";
    }

    @Property(name="containerDisplayName")
    @JsonIgnore
    public Optional<String> getContainerDisplayName() {
        return Optional.ofNullable(containerDisplayName);
    }

    public ResourceVisualization withContainerDisplayName(String containerDisplayName) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.containerDisplayName = containerDisplayName;
        return _x;
    }

    @Property(name="containerType")
    @JsonIgnore
    public Optional<String> getContainerType() {
        return Optional.ofNullable(containerType);
    }

    public ResourceVisualization withContainerType(String containerType) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.containerType = containerType;
        return _x;
    }

    @Property(name="containerWebUrl")
    @JsonIgnore
    public Optional<String> getContainerWebUrl() {
        return Optional.ofNullable(containerWebUrl);
    }

    public ResourceVisualization withContainerWebUrl(String containerWebUrl) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.containerWebUrl = containerWebUrl;
        return _x;
    }

    @Property(name="mediaType")
    @JsonIgnore
    public Optional<String> getMediaType() {
        return Optional.ofNullable(mediaType);
    }

    public ResourceVisualization withMediaType(String mediaType) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.mediaType = mediaType;
        return _x;
    }

    @Property(name="previewImageUrl")
    @JsonIgnore
    public Optional<String> getPreviewImageUrl() {
        return Optional.ofNullable(previewImageUrl);
    }

    public ResourceVisualization withPreviewImageUrl(String previewImageUrl) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.previewImageUrl = previewImageUrl;
        return _x;
    }

    @Property(name="previewText")
    @JsonIgnore
    public Optional<String> getPreviewText() {
        return Optional.ofNullable(previewText);
    }

    public ResourceVisualization withPreviewText(String previewText) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.previewText = previewText;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public ResourceVisualization withTitle(String title) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.title = title;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public ResourceVisualization withType(String type) {
        ResourceVisualization _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceVisualization");
        _x.type = type;
        return _x;
    }

    public ResourceVisualization withUnmappedField(String name, Object value) {
        ResourceVisualization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String containerDisplayName;
        private String containerType;
        private String containerWebUrl;
        private String mediaType;
        private String previewImageUrl;
        private String previewText;
        private String title;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder containerDisplayName(String containerDisplayName) {
            this.containerDisplayName = containerDisplayName;
            this.changedFields = changedFields.add("containerDisplayName");
            return this;
        }

        public Builder containerType(String containerType) {
            this.containerType = containerType;
            this.changedFields = changedFields.add("containerType");
            return this;
        }

        public Builder containerWebUrl(String containerWebUrl) {
            this.containerWebUrl = containerWebUrl;
            this.changedFields = changedFields.add("containerWebUrl");
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            this.changedFields = changedFields.add("mediaType");
            return this;
        }

        public Builder previewImageUrl(String previewImageUrl) {
            this.previewImageUrl = previewImageUrl;
            this.changedFields = changedFields.add("previewImageUrl");
            return this;
        }

        public Builder previewText(String previewText) {
            this.previewText = previewText;
            this.changedFields = changedFields.add("previewText");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public ResourceVisualization build() {
            ResourceVisualization _x = new ResourceVisualization();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.resourceVisualization";
            _x.containerDisplayName = containerDisplayName;
            _x.containerType = containerType;
            _x.containerWebUrl = containerWebUrl;
            _x.mediaType = mediaType;
            _x.previewImageUrl = previewImageUrl;
            _x.previewText = previewText;
            _x.title = title;
            _x.type = type;
            return _x;
        }
    }

    private ResourceVisualization _copy() {
        ResourceVisualization _x = new ResourceVisualization();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.containerDisplayName = containerDisplayName;
        _x.containerType = containerType;
        _x.containerWebUrl = containerWebUrl;
        _x.mediaType = mediaType;
        _x.previewImageUrl = previewImageUrl;
        _x.previewText = previewText;
        _x.title = title;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceVisualization[");
        b.append("containerDisplayName=");
        b.append(this.containerDisplayName);
        b.append(", ");
        b.append("containerType=");
        b.append(this.containerType);
        b.append(", ");
        b.append("containerWebUrl=");
        b.append(this.containerWebUrl);
        b.append(", ");
        b.append("mediaType=");
        b.append(this.mediaType);
        b.append(", ");
        b.append("previewImageUrl=");
        b.append(this.previewImageUrl);
        b.append(", ");
        b.append("previewText=");
        b.append(this.previewText);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
