package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "acceptRequests", 
    "allowedRequestors", 
    "scopeType"})
@JsonInclude(Include.NON_NULL)
public class RequestorSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("acceptRequests")
    protected Boolean acceptRequests;

    @JsonProperty("allowedRequestors")
    protected List<UserSet> allowedRequestors;

    @JsonProperty("allowedRequestors@nextLink")
    protected String allowedRequestorsNextLink;

    @JsonProperty("scopeType")
    protected String scopeType;

    protected RequestorSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.requestorSettings";
    }

    @Property(name="acceptRequests")
    @JsonIgnore
    public Optional<Boolean> getAcceptRequests() {
        return Optional.ofNullable(acceptRequests);
    }

    public RequestorSettings withAcceptRequests(Boolean acceptRequests) {
        RequestorSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requestorSettings");
        _x.acceptRequests = acceptRequests;
        return _x;
    }

    @Property(name="allowedRequestors")
    @JsonIgnore
    public CollectionPage<UserSet> getAllowedRequestors() {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, this.allowedRequestors, Optional.ofNullable(allowedRequestorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="allowedRequestors")
    @JsonIgnore
    public CollectionPage<UserSet> getAllowedRequestors(HttpRequestOptions options) {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, this.allowedRequestors, Optional.ofNullable(allowedRequestorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="scopeType")
    @JsonIgnore
    public Optional<String> getScopeType() {
        return Optional.ofNullable(scopeType);
    }

    public RequestorSettings withScopeType(String scopeType) {
        RequestorSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requestorSettings");
        _x.scopeType = scopeType;
        return _x;
    }

    public RequestorSettings withUnmappedField(String name, Object value) {
        RequestorSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean acceptRequests;
        private List<UserSet> allowedRequestors;
        private String allowedRequestorsNextLink;
        private String scopeType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder acceptRequests(Boolean acceptRequests) {
            this.acceptRequests = acceptRequests;
            this.changedFields = changedFields.add("acceptRequests");
            return this;
        }

        public Builder allowedRequestors(List<UserSet> allowedRequestors) {
            this.allowedRequestors = allowedRequestors;
            this.changedFields = changedFields.add("allowedRequestors");
            return this;
        }

        public Builder allowedRequestors(UserSet... allowedRequestors) {
            return allowedRequestors(Arrays.asList(allowedRequestors));
        }

        public Builder allowedRequestorsNextLink(String allowedRequestorsNextLink) {
            this.allowedRequestorsNextLink = allowedRequestorsNextLink;
            this.changedFields = changedFields.add("allowedRequestors");
            return this;
        }

        public Builder scopeType(String scopeType) {
            this.scopeType = scopeType;
            this.changedFields = changedFields.add("scopeType");
            return this;
        }

        public RequestorSettings build() {
            RequestorSettings _x = new RequestorSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.requestorSettings";
            _x.acceptRequests = acceptRequests;
            _x.allowedRequestors = allowedRequestors;
            _x.allowedRequestorsNextLink = allowedRequestorsNextLink;
            _x.scopeType = scopeType;
            return _x;
        }
    }

    private RequestorSettings _copy() {
        RequestorSettings _x = new RequestorSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.acceptRequests = acceptRequests;
        _x.allowedRequestors = allowedRequestors;
        _x.scopeType = scopeType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequestorSettings[");
        b.append("acceptRequests=");
        b.append(this.acceptRequests);
        b.append(", ");
        b.append("allowedRequestors=");
        b.append(this.allowedRequestors);
        b.append(", ");
        b.append("scopeType=");
        b.append(this.scopeType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
