package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "expiration", 
    "recurrence", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class RequestSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("expiration")
    protected ExpirationPattern expiration;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected RequestSchedule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.requestSchedule";
    }

    @Property(name="expiration")
    @JsonIgnore
    public Optional<ExpirationPattern> getExpiration() {
        return Optional.ofNullable(expiration);
    }

    public RequestSchedule withExpiration(ExpirationPattern expiration) {
        RequestSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requestSchedule");
        _x.expiration = expiration;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public RequestSchedule withRecurrence(PatternedRecurrence recurrence) {
        RequestSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requestSchedule");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public RequestSchedule withStartDateTime(OffsetDateTime startDateTime) {
        RequestSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.requestSchedule");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public RequestSchedule withUnmappedField(String name, Object value) {
        RequestSchedule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ExpirationPattern expiration;
        private PatternedRecurrence recurrence;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder expiration(ExpirationPattern expiration) {
            this.expiration = expiration;
            this.changedFields = changedFields.add("expiration");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public RequestSchedule build() {
            RequestSchedule _x = new RequestSchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.requestSchedule";
            _x.expiration = expiration;
            _x.recurrence = recurrence;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    private RequestSchedule _copy() {
        RequestSchedule _x = new RequestSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.expiration = expiration;
        _x.recurrence = recurrence;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequestSchedule[");
        b.append("expiration=");
        b.append(this.expiration);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
