package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ContactRelationship;

@JsonPropertyOrder({
    "@odata.type", 
    "accessConsent", 
    "displayName", 
    "emailAddress", 
    "id", 
    "mobilePhone", 
    "relationship"})
@JsonInclude(Include.NON_NULL)
public class RelatedContact implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessConsent")
    protected Boolean accessConsent;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("emailAddress")
    protected String emailAddress;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("mobilePhone")
    protected String mobilePhone;

    @JsonProperty("relationship")
    protected ContactRelationship relationship;

    protected RelatedContact() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.relatedContact";
    }

    @Property(name="accessConsent")
    @JsonIgnore
    public Optional<Boolean> getAccessConsent() {
        return Optional.ofNullable(accessConsent);
    }

    public RelatedContact withAccessConsent(Boolean accessConsent) {
        RelatedContact _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedContact");
        _x.accessConsent = accessConsent;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RelatedContact withDisplayName(String displayName) {
        RelatedContact _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedContact");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public RelatedContact withEmailAddress(String emailAddress) {
        RelatedContact _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedContact");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public RelatedContact withId(String id) {
        RelatedContact _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedContact");
        _x.id = id;
        return _x;
    }

    @Property(name="mobilePhone")
    @JsonIgnore
    public Optional<String> getMobilePhone() {
        return Optional.ofNullable(mobilePhone);
    }

    public RelatedContact withMobilePhone(String mobilePhone) {
        RelatedContact _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedContact");
        _x.mobilePhone = mobilePhone;
        return _x;
    }

    @Property(name="relationship")
    @JsonIgnore
    public Optional<ContactRelationship> getRelationship() {
        return Optional.ofNullable(relationship);
    }

    public RelatedContact withRelationship(ContactRelationship relationship) {
        RelatedContact _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.relatedContact");
        _x.relationship = relationship;
        return _x;
    }

    public RelatedContact withUnmappedField(String name, Object value) {
        RelatedContact _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean accessConsent;
        private String displayName;
        private String emailAddress;
        private String id;
        private String mobilePhone;
        private ContactRelationship relationship;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessConsent(Boolean accessConsent) {
            this.accessConsent = accessConsent;
            this.changedFields = changedFields.add("accessConsent");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder mobilePhone(String mobilePhone) {
            this.mobilePhone = mobilePhone;
            this.changedFields = changedFields.add("mobilePhone");
            return this;
        }

        public Builder relationship(ContactRelationship relationship) {
            this.relationship = relationship;
            this.changedFields = changedFields.add("relationship");
            return this;
        }

        public RelatedContact build() {
            RelatedContact _x = new RelatedContact();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.relatedContact";
            _x.accessConsent = accessConsent;
            _x.displayName = displayName;
            _x.emailAddress = emailAddress;
            _x.id = id;
            _x.mobilePhone = mobilePhone;
            _x.relationship = relationship;
            return _x;
        }
    }

    private RelatedContact _copy() {
        RelatedContact _x = new RelatedContact();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessConsent = accessConsent;
        _x.displayName = displayName;
        _x.emailAddress = emailAddress;
        _x.id = id;
        _x.mobilePhone = mobilePhone;
        _x.relationship = relationship;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RelatedContact[");
        b.append("accessConsent=");
        b.append(this.accessConsent);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("mobilePhone=");
        b.append(this.mobilePhone);
        b.append(", ");
        b.append("relationship=");
        b.append(this.relationship);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
