package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RegistryHive;
import odata.msgraph.client.beta.enums.RegistryOperation;
import odata.msgraph.client.beta.enums.RegistryValueType;

@JsonPropertyOrder({
    "@odata.type", 
    "hive", 
    "key", 
    "oldKey", 
    "oldValueData", 
    "oldValueName", 
    "operation", 
    "processId", 
    "valueData", 
    "valueName", 
    "valueType"})
@JsonInclude(Include.NON_NULL)
public class RegistryKeyState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hive")
    protected RegistryHive hive;

    @JsonProperty("key")
    protected String key;

    @JsonProperty("oldKey")
    protected String oldKey;

    @JsonProperty("oldValueData")
    protected String oldValueData;

    @JsonProperty("oldValueName")
    protected String oldValueName;

    @JsonProperty("operation")
    protected RegistryOperation operation;

    @JsonProperty("processId")
    protected Integer processId;

    @JsonProperty("valueData")
    protected String valueData;

    @JsonProperty("valueName")
    protected String valueName;

    @JsonProperty("valueType")
    protected RegistryValueType valueType;

    protected RegistryKeyState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.registryKeyState";
    }

    @Property(name="hive")
    @JsonIgnore
    public Optional<RegistryHive> getHive() {
        return Optional.ofNullable(hive);
    }

    public RegistryKeyState withHive(RegistryHive hive) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.hive = hive;
        return _x;
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public RegistryKeyState withKey(String key) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.key = key;
        return _x;
    }

    @Property(name="oldKey")
    @JsonIgnore
    public Optional<String> getOldKey() {
        return Optional.ofNullable(oldKey);
    }

    public RegistryKeyState withOldKey(String oldKey) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.oldKey = oldKey;
        return _x;
    }

    @Property(name="oldValueData")
    @JsonIgnore
    public Optional<String> getOldValueData() {
        return Optional.ofNullable(oldValueData);
    }

    public RegistryKeyState withOldValueData(String oldValueData) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.oldValueData = oldValueData;
        return _x;
    }

    @Property(name="oldValueName")
    @JsonIgnore
    public Optional<String> getOldValueName() {
        return Optional.ofNullable(oldValueName);
    }

    public RegistryKeyState withOldValueName(String oldValueName) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.oldValueName = oldValueName;
        return _x;
    }

    @Property(name="operation")
    @JsonIgnore
    public Optional<RegistryOperation> getOperation() {
        return Optional.ofNullable(operation);
    }

    public RegistryKeyState withOperation(RegistryOperation operation) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.operation = operation;
        return _x;
    }

    @Property(name="processId")
    @JsonIgnore
    public Optional<Integer> getProcessId() {
        return Optional.ofNullable(processId);
    }

    public RegistryKeyState withProcessId(Integer processId) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.processId = processId;
        return _x;
    }

    @Property(name="valueData")
    @JsonIgnore
    public Optional<String> getValueData() {
        return Optional.ofNullable(valueData);
    }

    public RegistryKeyState withValueData(String valueData) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.valueData = valueData;
        return _x;
    }

    @Property(name="valueName")
    @JsonIgnore
    public Optional<String> getValueName() {
        return Optional.ofNullable(valueName);
    }

    public RegistryKeyState withValueName(String valueName) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.valueName = valueName;
        return _x;
    }

    @Property(name="valueType")
    @JsonIgnore
    public Optional<RegistryValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    public RegistryKeyState withValueType(RegistryValueType valueType) {
        RegistryKeyState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registryKeyState");
        _x.valueType = valueType;
        return _x;
    }

    public RegistryKeyState withUnmappedField(String name, Object value) {
        RegistryKeyState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RegistryHive hive;
        private String key;
        private String oldKey;
        private String oldValueData;
        private String oldValueName;
        private RegistryOperation operation;
        private Integer processId;
        private String valueData;
        private String valueName;
        private RegistryValueType valueType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder hive(RegistryHive hive) {
            this.hive = hive;
            this.changedFields = changedFields.add("hive");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public Builder oldKey(String oldKey) {
            this.oldKey = oldKey;
            this.changedFields = changedFields.add("oldKey");
            return this;
        }

        public Builder oldValueData(String oldValueData) {
            this.oldValueData = oldValueData;
            this.changedFields = changedFields.add("oldValueData");
            return this;
        }

        public Builder oldValueName(String oldValueName) {
            this.oldValueName = oldValueName;
            this.changedFields = changedFields.add("oldValueName");
            return this;
        }

        public Builder operation(RegistryOperation operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("operation");
            return this;
        }

        public Builder processId(Integer processId) {
            this.processId = processId;
            this.changedFields = changedFields.add("processId");
            return this;
        }

        public Builder valueData(String valueData) {
            this.valueData = valueData;
            this.changedFields = changedFields.add("valueData");
            return this;
        }

        public Builder valueName(String valueName) {
            this.valueName = valueName;
            this.changedFields = changedFields.add("valueName");
            return this;
        }

        public Builder valueType(RegistryValueType valueType) {
            this.valueType = valueType;
            this.changedFields = changedFields.add("valueType");
            return this;
        }

        public RegistryKeyState build() {
            RegistryKeyState _x = new RegistryKeyState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.registryKeyState";
            _x.hive = hive;
            _x.key = key;
            _x.oldKey = oldKey;
            _x.oldValueData = oldValueData;
            _x.oldValueName = oldValueName;
            _x.operation = operation;
            _x.processId = processId;
            _x.valueData = valueData;
            _x.valueName = valueName;
            _x.valueType = valueType;
            return _x;
        }
    }

    private RegistryKeyState _copy() {
        RegistryKeyState _x = new RegistryKeyState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hive = hive;
        _x.key = key;
        _x.oldKey = oldKey;
        _x.oldValueData = oldValueData;
        _x.oldValueName = oldValueName;
        _x.operation = operation;
        _x.processId = processId;
        _x.valueData = valueData;
        _x.valueName = valueName;
        _x.valueType = valueType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RegistryKeyState[");
        b.append("hive=");
        b.append(this.hive);
        b.append(", ");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("oldKey=");
        b.append(this.oldKey);
        b.append(", ");
        b.append("oldValueData=");
        b.append(this.oldValueData);
        b.append(", ");
        b.append("oldValueName=");
        b.append(this.oldValueName);
        b.append(", ");
        b.append("operation=");
        b.append(this.operation);
        b.append(", ");
        b.append("processId=");
        b.append(this.processId);
        b.append(", ");
        b.append("valueData=");
        b.append(this.valueData);
        b.append(", ");
        b.append("valueName=");
        b.append(this.valueName);
        b.append(", ");
        b.append("valueType=");
        b.append(this.valueType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
