package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethodsRegistrationCampaign"})
@JsonInclude(Include.NON_NULL)
public class RegistrationEnforcement implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authenticationMethodsRegistrationCampaign")
    protected AuthenticationMethodsRegistrationCampaign authenticationMethodsRegistrationCampaign;

    protected RegistrationEnforcement() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.registrationEnforcement";
    }

    @Property(name="authenticationMethodsRegistrationCampaign")
    @JsonIgnore
    public Optional<AuthenticationMethodsRegistrationCampaign> getAuthenticationMethodsRegistrationCampaign() {
        return Optional.ofNullable(authenticationMethodsRegistrationCampaign);
    }

    public RegistrationEnforcement withAuthenticationMethodsRegistrationCampaign(AuthenticationMethodsRegistrationCampaign authenticationMethodsRegistrationCampaign) {
        RegistrationEnforcement _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.registrationEnforcement");
        _x.authenticationMethodsRegistrationCampaign = authenticationMethodsRegistrationCampaign;
        return _x;
    }

    public RegistrationEnforcement withUnmappedField(String name, Object value) {
        RegistrationEnforcement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationMethodsRegistrationCampaign authenticationMethodsRegistrationCampaign;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder authenticationMethodsRegistrationCampaign(AuthenticationMethodsRegistrationCampaign authenticationMethodsRegistrationCampaign) {
            this.authenticationMethodsRegistrationCampaign = authenticationMethodsRegistrationCampaign;
            this.changedFields = changedFields.add("authenticationMethodsRegistrationCampaign");
            return this;
        }

        public RegistrationEnforcement build() {
            RegistrationEnforcement _x = new RegistrationEnforcement();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.registrationEnforcement";
            _x.authenticationMethodsRegistrationCampaign = authenticationMethodsRegistrationCampaign;
            return _x;
        }
    }

    private RegistrationEnforcement _copy() {
        RegistrationEnforcement _x = new RegistrationEnforcement();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authenticationMethodsRegistrationCampaign = authenticationMethodsRegistrationCampaign;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RegistrationEnforcement[");
        b.append("authenticationMethodsRegistrationCampaign=");
        b.append(this.authenticationMethodsRegistrationCampaign);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
