package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "calendar", 
    "firstDayOfWeek", 
    "longDateFormat", 
    "longTimeFormat", 
    "shortDateFormat", 
    "shortTimeFormat", 
    "timeZone"})
@JsonInclude(Include.NON_NULL)
public class RegionalFormatOverrides implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("calendar")
    protected String calendar;

    @JsonProperty("firstDayOfWeek")
    protected String firstDayOfWeek;

    @JsonProperty("longDateFormat")
    protected String longDateFormat;

    @JsonProperty("longTimeFormat")
    protected String longTimeFormat;

    @JsonProperty("shortDateFormat")
    protected String shortDateFormat;

    @JsonProperty("shortTimeFormat")
    protected String shortTimeFormat;

    @JsonProperty("timeZone")
    protected String timeZone;

    protected RegionalFormatOverrides() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.regionalFormatOverrides";
    }

    @Property(name="calendar")
    @JsonIgnore
    public Optional<String> getCalendar() {
        return Optional.ofNullable(calendar);
    }

    public RegionalFormatOverrides withCalendar(String calendar) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.calendar = calendar;
        return _x;
    }

    @Property(name="firstDayOfWeek")
    @JsonIgnore
    public Optional<String> getFirstDayOfWeek() {
        return Optional.ofNullable(firstDayOfWeek);
    }

    public RegionalFormatOverrides withFirstDayOfWeek(String firstDayOfWeek) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.firstDayOfWeek = firstDayOfWeek;
        return _x;
    }

    @Property(name="longDateFormat")
    @JsonIgnore
    public Optional<String> getLongDateFormat() {
        return Optional.ofNullable(longDateFormat);
    }

    public RegionalFormatOverrides withLongDateFormat(String longDateFormat) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.longDateFormat = longDateFormat;
        return _x;
    }

    @Property(name="longTimeFormat")
    @JsonIgnore
    public Optional<String> getLongTimeFormat() {
        return Optional.ofNullable(longTimeFormat);
    }

    public RegionalFormatOverrides withLongTimeFormat(String longTimeFormat) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.longTimeFormat = longTimeFormat;
        return _x;
    }

    @Property(name="shortDateFormat")
    @JsonIgnore
    public Optional<String> getShortDateFormat() {
        return Optional.ofNullable(shortDateFormat);
    }

    public RegionalFormatOverrides withShortDateFormat(String shortDateFormat) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.shortDateFormat = shortDateFormat;
        return _x;
    }

    @Property(name="shortTimeFormat")
    @JsonIgnore
    public Optional<String> getShortTimeFormat() {
        return Optional.ofNullable(shortTimeFormat);
    }

    public RegionalFormatOverrides withShortTimeFormat(String shortTimeFormat) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.shortTimeFormat = shortTimeFormat;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public RegionalFormatOverrides withTimeZone(String timeZone) {
        RegionalFormatOverrides _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.regionalFormatOverrides");
        _x.timeZone = timeZone;
        return _x;
    }

    public RegionalFormatOverrides withUnmappedField(String name, Object value) {
        RegionalFormatOverrides _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String calendar;
        private String firstDayOfWeek;
        private String longDateFormat;
        private String longTimeFormat;
        private String shortDateFormat;
        private String shortTimeFormat;
        private String timeZone;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder calendar(String calendar) {
            this.calendar = calendar;
            this.changedFields = changedFields.add("calendar");
            return this;
        }

        public Builder firstDayOfWeek(String firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            this.changedFields = changedFields.add("firstDayOfWeek");
            return this;
        }

        public Builder longDateFormat(String longDateFormat) {
            this.longDateFormat = longDateFormat;
            this.changedFields = changedFields.add("longDateFormat");
            return this;
        }

        public Builder longTimeFormat(String longTimeFormat) {
            this.longTimeFormat = longTimeFormat;
            this.changedFields = changedFields.add("longTimeFormat");
            return this;
        }

        public Builder shortDateFormat(String shortDateFormat) {
            this.shortDateFormat = shortDateFormat;
            this.changedFields = changedFields.add("shortDateFormat");
            return this;
        }

        public Builder shortTimeFormat(String shortTimeFormat) {
            this.shortTimeFormat = shortTimeFormat;
            this.changedFields = changedFields.add("shortTimeFormat");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public RegionalFormatOverrides build() {
            RegionalFormatOverrides _x = new RegionalFormatOverrides();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.regionalFormatOverrides";
            _x.calendar = calendar;
            _x.firstDayOfWeek = firstDayOfWeek;
            _x.longDateFormat = longDateFormat;
            _x.longTimeFormat = longTimeFormat;
            _x.shortDateFormat = shortDateFormat;
            _x.shortTimeFormat = shortTimeFormat;
            _x.timeZone = timeZone;
            return _x;
        }
    }

    private RegionalFormatOverrides _copy() {
        RegionalFormatOverrides _x = new RegionalFormatOverrides();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.calendar = calendar;
        _x.firstDayOfWeek = firstDayOfWeek;
        _x.longDateFormat = longDateFormat;
        _x.longTimeFormat = longTimeFormat;
        _x.shortDateFormat = shortDateFormat;
        _x.shortTimeFormat = shortTimeFormat;
        _x.timeZone = timeZone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RegionalFormatOverrides[");
        b.append("calendar=");
        b.append(this.calendar);
        b.append(", ");
        b.append("firstDayOfWeek=");
        b.append(this.firstDayOfWeek);
        b.append(", ");
        b.append("longDateFormat=");
        b.append(this.longDateFormat);
        b.append(", ");
        b.append("longTimeFormat=");
        b.append(this.longTimeFormat);
        b.append(", ");
        b.append("shortDateFormat=");
        b.append(this.shortDateFormat);
        b.append(", ");
        b.append("shortTimeFormat=");
        b.append(this.shortTimeFormat);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
