package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RecordingStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "initiatedBy", 
    "initiator", 
    "recordingStatus"})
@JsonInclude(Include.NON_NULL)
public class RecordingInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("initiatedBy")
    protected ParticipantInfo initiatedBy;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("recordingStatus")
    protected RecordingStatus recordingStatus;

    protected RecordingInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recordingInfo";
    }

    @Property(name="initiatedBy")
    @JsonIgnore
    public Optional<ParticipantInfo> getInitiatedBy() {
        return Optional.ofNullable(initiatedBy);
    }

    public RecordingInfo withInitiatedBy(ParticipantInfo initiatedBy) {
        RecordingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recordingInfo");
        _x.initiatedBy = initiatedBy;
        return _x;
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public RecordingInfo withInitiator(IdentitySet initiator) {
        RecordingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recordingInfo");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="recordingStatus")
    @JsonIgnore
    public Optional<RecordingStatus> getRecordingStatus() {
        return Optional.ofNullable(recordingStatus);
    }

    public RecordingInfo withRecordingStatus(RecordingStatus recordingStatus) {
        RecordingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recordingInfo");
        _x.recordingStatus = recordingStatus;
        return _x;
    }

    public RecordingInfo withUnmappedField(String name, Object value) {
        RecordingInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ParticipantInfo initiatedBy;
        private IdentitySet initiator;
        private RecordingStatus recordingStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder initiatedBy(ParticipantInfo initiatedBy) {
            this.initiatedBy = initiatedBy;
            this.changedFields = changedFields.add("initiatedBy");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder recordingStatus(RecordingStatus recordingStatus) {
            this.recordingStatus = recordingStatus;
            this.changedFields = changedFields.add("recordingStatus");
            return this;
        }

        public RecordingInfo build() {
            RecordingInfo _x = new RecordingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.recordingInfo";
            _x.initiatedBy = initiatedBy;
            _x.initiator = initiator;
            _x.recordingStatus = recordingStatus;
            return _x;
        }
    }

    private RecordingInfo _copy() {
        RecordingInfo _x = new RecordingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.initiatedBy = initiatedBy;
        _x.initiator = initiator;
        _x.recordingStatus = recordingStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecordingInfo[");
        b.append("initiatedBy=");
        b.append(this.initiatedBy);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("recordingStatus=");
        b.append(this.recordingStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
