package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.OnenoteSourceService;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "lastAccessedTime", 
    "links", 
    "sourceService"})
@JsonInclude(Include.NON_NULL)
public class RecentNotebook implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastAccessedTime")
    protected OffsetDateTime lastAccessedTime;

    @JsonProperty("links")
    protected RecentNotebookLinks links;

    @JsonProperty("sourceService")
    protected OnenoteSourceService sourceService;

    protected RecentNotebook() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.recentNotebook";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RecentNotebook withDisplayName(String displayName) {
        RecentNotebook _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recentNotebook");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastAccessedTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastAccessedTime() {
        return Optional.ofNullable(lastAccessedTime);
    }

    public RecentNotebook withLastAccessedTime(OffsetDateTime lastAccessedTime) {
        RecentNotebook _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recentNotebook");
        _x.lastAccessedTime = lastAccessedTime;
        return _x;
    }

    @Property(name="links")
    @JsonIgnore
    public Optional<RecentNotebookLinks> getLinks() {
        return Optional.ofNullable(links);
    }

    public RecentNotebook withLinks(RecentNotebookLinks links) {
        RecentNotebook _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recentNotebook");
        _x.links = links;
        return _x;
    }

    @Property(name="sourceService")
    @JsonIgnore
    public Optional<OnenoteSourceService> getSourceService() {
        return Optional.ofNullable(sourceService);
    }

    public RecentNotebook withSourceService(OnenoteSourceService sourceService) {
        RecentNotebook _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.recentNotebook");
        _x.sourceService = sourceService;
        return _x;
    }

    public RecentNotebook withUnmappedField(String name, Object value) {
        RecentNotebook _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private OffsetDateTime lastAccessedTime;
        private RecentNotebookLinks links;
        private OnenoteSourceService sourceService;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastAccessedTime(OffsetDateTime lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
            this.changedFields = changedFields.add("lastAccessedTime");
            return this;
        }

        public Builder links(RecentNotebookLinks links) {
            this.links = links;
            this.changedFields = changedFields.add("links");
            return this;
        }

        public Builder sourceService(OnenoteSourceService sourceService) {
            this.sourceService = sourceService;
            this.changedFields = changedFields.add("sourceService");
            return this;
        }

        public RecentNotebook build() {
            RecentNotebook _x = new RecentNotebook();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.recentNotebook";
            _x.displayName = displayName;
            _x.lastAccessedTime = lastAccessedTime;
            _x.links = links;
            _x.sourceService = sourceService;
            return _x;
        }
    }

    private RecentNotebook _copy() {
        RecentNotebook _x = new RecentNotebook();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.lastAccessedTime = lastAccessedTime;
        _x.links = links;
        _x.sourceService = sourceService;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecentNotebook[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastAccessedTime=");
        b.append(this.lastAccessedTime);
        b.append(", ");
        b.append("links=");
        b.append(this.links);
        b.append(", ");
        b.append("sourceService=");
        b.append(this.sourceService);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
