package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "deleted", 
    "remaining", 
    "state", 
    "storagePlanInformation", 
    "total", 
    "used"})
@JsonInclude(Include.NON_NULL)
public class Quota implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deleted")
    protected Long deleted;

    @JsonProperty("remaining")
    protected Long remaining;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("storagePlanInformation")
    protected StoragePlanInformation storagePlanInformation;

    @JsonProperty("total")
    protected Long total;

    @JsonProperty("used")
    protected Long used;

    protected Quota() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.quota";
    }

    @Property(name="deleted")
    @JsonIgnore
    public Optional<Long> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    public Quota withDeleted(Long deleted) {
        Quota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.quota");
        _x.deleted = deleted;
        return _x;
    }

    @Property(name="remaining")
    @JsonIgnore
    public Optional<Long> getRemaining() {
        return Optional.ofNullable(remaining);
    }

    public Quota withRemaining(Long remaining) {
        Quota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.quota");
        _x.remaining = remaining;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public Quota withState(String state) {
        Quota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.quota");
        _x.state = state;
        return _x;
    }

    @Property(name="storagePlanInformation")
    @JsonIgnore
    public Optional<StoragePlanInformation> getStoragePlanInformation() {
        return Optional.ofNullable(storagePlanInformation);
    }

    public Quota withStoragePlanInformation(StoragePlanInformation storagePlanInformation) {
        Quota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.quota");
        _x.storagePlanInformation = storagePlanInformation;
        return _x;
    }

    @Property(name="total")
    @JsonIgnore
    public Optional<Long> getTotal() {
        return Optional.ofNullable(total);
    }

    public Quota withTotal(Long total) {
        Quota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.quota");
        _x.total = total;
        return _x;
    }

    @Property(name="used")
    @JsonIgnore
    public Optional<Long> getUsed() {
        return Optional.ofNullable(used);
    }

    public Quota withUsed(Long used) {
        Quota _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.quota");
        _x.used = used;
        return _x;
    }

    public Quota withUnmappedField(String name, Object value) {
        Quota _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long deleted;
        private Long remaining;
        private String state;
        private StoragePlanInformation storagePlanInformation;
        private Long total;
        private Long used;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder deleted(Long deleted) {
            this.deleted = deleted;
            this.changedFields = changedFields.add("deleted");
            return this;
        }

        public Builder remaining(Long remaining) {
            this.remaining = remaining;
            this.changedFields = changedFields.add("remaining");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder storagePlanInformation(StoragePlanInformation storagePlanInformation) {
            this.storagePlanInformation = storagePlanInformation;
            this.changedFields = changedFields.add("storagePlanInformation");
            return this;
        }

        public Builder total(Long total) {
            this.total = total;
            this.changedFields = changedFields.add("total");
            return this;
        }

        public Builder used(Long used) {
            this.used = used;
            this.changedFields = changedFields.add("used");
            return this;
        }

        public Quota build() {
            Quota _x = new Quota();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.quota";
            _x.deleted = deleted;
            _x.remaining = remaining;
            _x.state = state;
            _x.storagePlanInformation = storagePlanInformation;
            _x.total = total;
            _x.used = used;
            return _x;
        }
    }

    private Quota _copy() {
        Quota _x = new Quota();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deleted = deleted;
        _x.remaining = remaining;
        _x.state = state;
        _x.storagePlanInformation = storagePlanInformation;
        _x.total = total;
        _x.used = used;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Quota[");
        b.append("deleted=");
        b.append(this.deleted);
        b.append(", ");
        b.append("remaining=");
        b.append(this.remaining);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("storagePlanInformation=");
        b.append(this.storagePlanInformation);
        b.append(", ");
        b.append("total=");
        b.append(this.total);
        b.append(", ");
        b.append("used=");
        b.append(this.used);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
