package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ProvisioningStatusErrorCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "additionalDetails", 
    "errorCategory", 
    "errorCode", 
    "reason", 
    "recommendedAction"})
@JsonInclude(Include.NON_NULL)
public class ProvisioningErrorInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("additionalDetails")
    protected String additionalDetails;

    @JsonProperty("errorCategory")
    protected ProvisioningStatusErrorCategory errorCategory;

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("reason")
    protected String reason;

    @JsonProperty("recommendedAction")
    protected String recommendedAction;

    protected ProvisioningErrorInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.provisioningErrorInfo";
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public Optional<String> getAdditionalDetails() {
        return Optional.ofNullable(additionalDetails);
    }

    public ProvisioningErrorInfo withAdditionalDetails(String additionalDetails) {
        ProvisioningErrorInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningErrorInfo");
        _x.additionalDetails = additionalDetails;
        return _x;
    }

    @Property(name="errorCategory")
    @JsonIgnore
    public Optional<ProvisioningStatusErrorCategory> getErrorCategory() {
        return Optional.ofNullable(errorCategory);
    }

    public ProvisioningErrorInfo withErrorCategory(ProvisioningStatusErrorCategory errorCategory) {
        ProvisioningErrorInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningErrorInfo");
        _x.errorCategory = errorCategory;
        return _x;
    }

    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public ProvisioningErrorInfo withErrorCode(String errorCode) {
        ProvisioningErrorInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningErrorInfo");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    public ProvisioningErrorInfo withReason(String reason) {
        ProvisioningErrorInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningErrorInfo");
        _x.reason = reason;
        return _x;
    }

    @Property(name="recommendedAction")
    @JsonIgnore
    public Optional<String> getRecommendedAction() {
        return Optional.ofNullable(recommendedAction);
    }

    public ProvisioningErrorInfo withRecommendedAction(String recommendedAction) {
        ProvisioningErrorInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.provisioningErrorInfo");
        _x.recommendedAction = recommendedAction;
        return _x;
    }

    public ProvisioningErrorInfo withUnmappedField(String name, Object value) {
        ProvisioningErrorInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String additionalDetails;
        private ProvisioningStatusErrorCategory errorCategory;
        private String errorCode;
        private String reason;
        private String recommendedAction;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder additionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public Builder errorCategory(ProvisioningStatusErrorCategory errorCategory) {
            this.errorCategory = errorCategory;
            this.changedFields = changedFields.add("errorCategory");
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public Builder recommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
            this.changedFields = changedFields.add("recommendedAction");
            return this;
        }

        public ProvisioningErrorInfo build() {
            ProvisioningErrorInfo _x = new ProvisioningErrorInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.provisioningErrorInfo";
            _x.additionalDetails = additionalDetails;
            _x.errorCategory = errorCategory;
            _x.errorCode = errorCode;
            _x.reason = reason;
            _x.recommendedAction = recommendedAction;
            return _x;
        }
    }

    private ProvisioningErrorInfo _copy() {
        ProvisioningErrorInfo _x = new ProvisioningErrorInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.additionalDetails = additionalDetails;
        _x.errorCategory = errorCategory;
        _x.errorCode = errorCode;
        _x.reason = reason;
        _x.recommendedAction = recommendedAction;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProvisioningErrorInfo[");
        b.append("additionalDetails=");
        b.append(this.additionalDetails);
        b.append(", ");
        b.append("errorCategory=");
        b.append(this.errorCategory);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append(", ");
        b.append("recommendedAction=");
        b.append(this.recommendedAction);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
