package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.OnlineMeetingForwarders;
import odata.msgraph.client.beta.enums.OnlineMeetingPresenters;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedForwarders", 
    "allowedPresenters", 
    "isCopyToClipboardEnabled", 
    "isLobbyEnabled", 
    "lobbyBypassSettings"})
@JsonInclude(Include.NON_NULL)
public class ProtectOnlineMeetingAction extends LabelActionBase implements ODataType {

    @JsonProperty("allowedForwarders")
    protected OnlineMeetingForwarders allowedForwarders;

    @JsonProperty("allowedPresenters")
    protected OnlineMeetingPresenters allowedPresenters;

    @JsonProperty("isCopyToClipboardEnabled")
    protected Boolean isCopyToClipboardEnabled;

    @JsonProperty("isLobbyEnabled")
    protected Boolean isLobbyEnabled;

    @JsonProperty("lobbyBypassSettings")
    protected LobbyBypassSettings lobbyBypassSettings;

    protected ProtectOnlineMeetingAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.protectOnlineMeetingAction";
    }

    @Property(name="allowedForwarders")
    @JsonIgnore
    public Optional<OnlineMeetingForwarders> getAllowedForwarders() {
        return Optional.ofNullable(allowedForwarders);
    }

    public ProtectOnlineMeetingAction withAllowedForwarders(OnlineMeetingForwarders allowedForwarders) {
        ProtectOnlineMeetingAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectOnlineMeetingAction");
        _x.allowedForwarders = allowedForwarders;
        return _x;
    }

    @Property(name="allowedPresenters")
    @JsonIgnore
    public Optional<OnlineMeetingPresenters> getAllowedPresenters() {
        return Optional.ofNullable(allowedPresenters);
    }

    public ProtectOnlineMeetingAction withAllowedPresenters(OnlineMeetingPresenters allowedPresenters) {
        ProtectOnlineMeetingAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectOnlineMeetingAction");
        _x.allowedPresenters = allowedPresenters;
        return _x;
    }

    @Property(name="isCopyToClipboardEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsCopyToClipboardEnabled() {
        return Optional.ofNullable(isCopyToClipboardEnabled);
    }

    public ProtectOnlineMeetingAction withIsCopyToClipboardEnabled(Boolean isCopyToClipboardEnabled) {
        ProtectOnlineMeetingAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectOnlineMeetingAction");
        _x.isCopyToClipboardEnabled = isCopyToClipboardEnabled;
        return _x;
    }

    @Property(name="isLobbyEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsLobbyEnabled() {
        return Optional.ofNullable(isLobbyEnabled);
    }

    public ProtectOnlineMeetingAction withIsLobbyEnabled(Boolean isLobbyEnabled) {
        ProtectOnlineMeetingAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectOnlineMeetingAction");
        _x.isLobbyEnabled = isLobbyEnabled;
        return _x;
    }

    @Property(name="lobbyBypassSettings")
    @JsonIgnore
    public Optional<LobbyBypassSettings> getLobbyBypassSettings() {
        return Optional.ofNullable(lobbyBypassSettings);
    }

    public ProtectOnlineMeetingAction withLobbyBypassSettings(LobbyBypassSettings lobbyBypassSettings) {
        ProtectOnlineMeetingAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectOnlineMeetingAction");
        _x.lobbyBypassSettings = lobbyBypassSettings;
        return _x;
    }

    public ProtectOnlineMeetingAction withUnmappedField(String name, Object value) {
        ProtectOnlineMeetingAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProtectOnlineMeetingAction() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private OnlineMeetingForwarders allowedForwarders;
        private OnlineMeetingPresenters allowedPresenters;
        private Boolean isCopyToClipboardEnabled;
        private Boolean isLobbyEnabled;
        private LobbyBypassSettings lobbyBypassSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder allowedForwarders(OnlineMeetingForwarders allowedForwarders) {
            this.allowedForwarders = allowedForwarders;
            this.changedFields = changedFields.add("allowedForwarders");
            return this;
        }

        public Builder allowedPresenters(OnlineMeetingPresenters allowedPresenters) {
            this.allowedPresenters = allowedPresenters;
            this.changedFields = changedFields.add("allowedPresenters");
            return this;
        }

        public Builder isCopyToClipboardEnabled(Boolean isCopyToClipboardEnabled) {
            this.isCopyToClipboardEnabled = isCopyToClipboardEnabled;
            this.changedFields = changedFields.add("isCopyToClipboardEnabled");
            return this;
        }

        public Builder isLobbyEnabled(Boolean isLobbyEnabled) {
            this.isLobbyEnabled = isLobbyEnabled;
            this.changedFields = changedFields.add("isLobbyEnabled");
            return this;
        }

        public Builder lobbyBypassSettings(LobbyBypassSettings lobbyBypassSettings) {
            this.lobbyBypassSettings = lobbyBypassSettings;
            this.changedFields = changedFields.add("lobbyBypassSettings");
            return this;
        }

        public ProtectOnlineMeetingAction build() {
            ProtectOnlineMeetingAction _x = new ProtectOnlineMeetingAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.protectOnlineMeetingAction";
            _x.name = name;
            _x.allowedForwarders = allowedForwarders;
            _x.allowedPresenters = allowedPresenters;
            _x.isCopyToClipboardEnabled = isCopyToClipboardEnabled;
            _x.isLobbyEnabled = isLobbyEnabled;
            _x.lobbyBypassSettings = lobbyBypassSettings;
            return _x;
        }
    }

    private ProtectOnlineMeetingAction _copy() {
        ProtectOnlineMeetingAction _x = new ProtectOnlineMeetingAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.allowedForwarders = allowedForwarders;
        _x.allowedPresenters = allowedPresenters;
        _x.isCopyToClipboardEnabled = isCopyToClipboardEnabled;
        _x.isLobbyEnabled = isLobbyEnabled;
        _x.lobbyBypassSettings = lobbyBypassSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProtectOnlineMeetingAction[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("allowedForwarders=");
        b.append(this.allowedForwarders);
        b.append(", ");
        b.append("allowedPresenters=");
        b.append(this.allowedPresenters);
        b.append(", ");
        b.append("isCopyToClipboardEnabled=");
        b.append(this.isCopyToClipboardEnabled);
        b.append(", ");
        b.append("isLobbyEnabled=");
        b.append(this.isLobbyEnabled);
        b.append(", ");
        b.append("lobbyBypassSettings=");
        b.append(this.lobbyBypassSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
