package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "templateId"})
@JsonInclude(Include.NON_NULL)
public class ProtectByTemplateAction extends InformationProtectionAction implements ODataType {

    @JsonProperty("templateId")
    protected String templateId;

    protected ProtectByTemplateAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.protectByTemplateAction";
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public ProtectByTemplateAction withTemplateId(String templateId) {
        ProtectByTemplateAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.protectByTemplateAction");
        _x.templateId = templateId;
        return _x;
    }

    public ProtectByTemplateAction withUnmappedField(String name, Object value) {
        ProtectByTemplateAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProtectByTemplateAction() {
        return new Builder();
    }

    public static final class Builder {
        private String templateId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public ProtectByTemplateAction build() {
            ProtectByTemplateAction _x = new ProtectByTemplateAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.protectByTemplateAction";
            _x.templateId = templateId;
            return _x;
        }
    }

    private ProtectByTemplateAction _copy() {
        ProtectByTemplateAction _x = new ProtectByTemplateAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.templateId = templateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProtectByTemplateAction[");
        b.append("templateId=");
        b.append(this.templateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
