package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "policyId", 
    "policyName", 
    "policyTenantId", 
    "resourceId"})
@JsonInclude(Include.NON_NULL)
public class PrivateLinkDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("policyId")
    protected String policyId;

    @JsonProperty("policyName")
    protected String policyName;

    @JsonProperty("policyTenantId")
    protected String policyTenantId;

    @JsonProperty("resourceId")
    protected String resourceId;

    protected PrivateLinkDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privateLinkDetails";
    }

    @Property(name="policyId")
    @JsonIgnore
    public Optional<String> getPolicyId() {
        return Optional.ofNullable(policyId);
    }

    public PrivateLinkDetails withPolicyId(String policyId) {
        PrivateLinkDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privateLinkDetails");
        _x.policyId = policyId;
        return _x;
    }

    @Property(name="policyName")
    @JsonIgnore
    public Optional<String> getPolicyName() {
        return Optional.ofNullable(policyName);
    }

    public PrivateLinkDetails withPolicyName(String policyName) {
        PrivateLinkDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privateLinkDetails");
        _x.policyName = policyName;
        return _x;
    }

    @Property(name="policyTenantId")
    @JsonIgnore
    public Optional<String> getPolicyTenantId() {
        return Optional.ofNullable(policyTenantId);
    }

    public PrivateLinkDetails withPolicyTenantId(String policyTenantId) {
        PrivateLinkDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privateLinkDetails");
        _x.policyTenantId = policyTenantId;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public PrivateLinkDetails withResourceId(String resourceId) {
        PrivateLinkDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privateLinkDetails");
        _x.resourceId = resourceId;
        return _x;
    }

    public PrivateLinkDetails withUnmappedField(String name, Object value) {
        PrivateLinkDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String policyId;
        private String policyName;
        private String policyTenantId;
        private String resourceId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.changedFields = changedFields.add("policyId");
            return this;
        }

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            this.changedFields = changedFields.add("policyName");
            return this;
        }

        public Builder policyTenantId(String policyTenantId) {
            this.policyTenantId = policyTenantId;
            this.changedFields = changedFields.add("policyTenantId");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public PrivateLinkDetails build() {
            PrivateLinkDetails _x = new PrivateLinkDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privateLinkDetails";
            _x.policyId = policyId;
            _x.policyName = policyName;
            _x.policyTenantId = policyTenantId;
            _x.resourceId = resourceId;
            return _x;
        }
    }

    private PrivateLinkDetails _copy() {
        PrivateLinkDetails _x = new PrivateLinkDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.policyId = policyId;
        _x.policyName = policyName;
        _x.policyTenantId = policyTenantId;
        _x.resourceId = resourceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivateLinkDetails[");
        b.append("policyId=");
        b.append(this.policyId);
        b.append(", ");
        b.append("policyName=");
        b.append(this.policyName);
        b.append(", ");
        b.append("policyTenantId=");
        b.append(this.policyTenantId);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
