package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "contactEmail", 
    "statementUrl"})
@JsonInclude(Include.NON_NULL)
public class PrivacyProfile implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contactEmail")
    protected String contactEmail;

    @JsonProperty("statementUrl")
    protected String statementUrl;

    protected PrivacyProfile() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privacyProfile";
    }

    @Property(name="contactEmail")
    @JsonIgnore
    public Optional<String> getContactEmail() {
        return Optional.ofNullable(contactEmail);
    }

    public PrivacyProfile withContactEmail(String contactEmail) {
        PrivacyProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privacyProfile");
        _x.contactEmail = contactEmail;
        return _x;
    }

    @Property(name="statementUrl")
    @JsonIgnore
    public Optional<String> getStatementUrl() {
        return Optional.ofNullable(statementUrl);
    }

    public PrivacyProfile withStatementUrl(String statementUrl) {
        PrivacyProfile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privacyProfile");
        _x.statementUrl = statementUrl;
        return _x;
    }

    public PrivacyProfile withUnmappedField(String name, Object value) {
        PrivacyProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String contactEmail;
        private String statementUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            this.changedFields = changedFields.add("contactEmail");
            return this;
        }

        public Builder statementUrl(String statementUrl) {
            this.statementUrl = statementUrl;
            this.changedFields = changedFields.add("statementUrl");
            return this;
        }

        public PrivacyProfile build() {
            PrivacyProfile _x = new PrivacyProfile();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.privacyProfile";
            _x.contactEmail = contactEmail;
            _x.statementUrl = statementUrl;
            return _x;
        }
    }

    private PrivacyProfile _copy() {
        PrivacyProfile _x = new PrivacyProfile();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contactEmail = contactEmail;
        _x.statementUrl = statementUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivacyProfile[");
        b.append("contactEmail=");
        b.append(this.contactEmail);
        b.append(", ");
        b.append("statementUrl=");
        b.append(this.statementUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
