package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "altitudeInMeters", 
    "building", 
    "city", 
    "countryOrRegion", 
    "floor", 
    "floorDescription", 
    "floorNumber", 
    "latitude", 
    "longitude", 
    "organization", 
    "postalCode", 
    "roomDescription", 
    "roomName", 
    "roomNumber", 
    "site", 
    "stateOrProvince", 
    "streetAddress", 
    "subdivision", 
    "subunit"})
@JsonInclude(Include.NON_NULL)
public class PrinterLocation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("altitudeInMeters")
    protected Integer altitudeInMeters;

    @JsonProperty("building")
    protected String building;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("countryOrRegion")
    protected String countryOrRegion;

    @JsonProperty("floor")
    protected String floor;

    @JsonProperty("floorDescription")
    protected String floorDescription;

    @JsonProperty("floorNumber")
    protected Integer floorNumber;

    @JsonProperty("latitude")
    protected Double latitude;

    @JsonProperty("longitude")
    protected Double longitude;

    @JsonProperty("organization")
    protected List<String> organization;

    @JsonProperty("organization@nextLink")
    protected String organizationNextLink;

    @JsonProperty("postalCode")
    protected String postalCode;

    @JsonProperty("roomDescription")
    protected String roomDescription;

    @JsonProperty("roomName")
    protected String roomName;

    @JsonProperty("roomNumber")
    protected Integer roomNumber;

    @JsonProperty("site")
    protected String site;

    @JsonProperty("stateOrProvince")
    protected String stateOrProvince;

    @JsonProperty("streetAddress")
    protected String streetAddress;

    @JsonProperty("subdivision")
    protected List<String> subdivision;

    @JsonProperty("subdivision@nextLink")
    protected String subdivisionNextLink;

    @JsonProperty("subunit")
    protected List<String> subunit;

    @JsonProperty("subunit@nextLink")
    protected String subunitNextLink;

    protected PrinterLocation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerLocation";
    }

    @Property(name="altitudeInMeters")
    @JsonIgnore
    public Optional<Integer> getAltitudeInMeters() {
        return Optional.ofNullable(altitudeInMeters);
    }

    public PrinterLocation withAltitudeInMeters(Integer altitudeInMeters) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.altitudeInMeters = altitudeInMeters;
        return _x;
    }

    @Property(name="building")
    @JsonIgnore
    public Optional<String> getBuilding() {
        return Optional.ofNullable(building);
    }

    public PrinterLocation withBuilding(String building) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.building = building;
        return _x;
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public PrinterLocation withCity(String city) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.city = city;
        return _x;
    }

    @Property(name="countryOrRegion")
    @JsonIgnore
    public Optional<String> getCountryOrRegion() {
        return Optional.ofNullable(countryOrRegion);
    }

    public PrinterLocation withCountryOrRegion(String countryOrRegion) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.countryOrRegion = countryOrRegion;
        return _x;
    }

    @Property(name="floor")
    @JsonIgnore
    public Optional<String> getFloor() {
        return Optional.ofNullable(floor);
    }

    public PrinterLocation withFloor(String floor) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.floor = floor;
        return _x;
    }

    @Property(name="floorDescription")
    @JsonIgnore
    public Optional<String> getFloorDescription() {
        return Optional.ofNullable(floorDescription);
    }

    public PrinterLocation withFloorDescription(String floorDescription) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.floorDescription = floorDescription;
        return _x;
    }

    @Property(name="floorNumber")
    @JsonIgnore
    public Optional<Integer> getFloorNumber() {
        return Optional.ofNullable(floorNumber);
    }

    public PrinterLocation withFloorNumber(Integer floorNumber) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.floorNumber = floorNumber;
        return _x;
    }

    @Property(name="latitude")
    @JsonIgnore
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(latitude);
    }

    public PrinterLocation withLatitude(Double latitude) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.latitude = latitude;
        return _x;
    }

    @Property(name="longitude")
    @JsonIgnore
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(longitude);
    }

    public PrinterLocation withLongitude(Double longitude) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.longitude = longitude;
        return _x;
    }

    @Property(name="organization")
    @JsonIgnore
    public CollectionPage<String> getOrganization() {
        return new CollectionPage<String>(contextPath, String.class, this.organization, Optional.ofNullable(organizationNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="organization")
    @JsonIgnore
    public CollectionPage<String> getOrganization(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.organization, Optional.ofNullable(organizationNextLink), Collections.emptyList(), options);
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public PrinterLocation withPostalCode(String postalCode) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.postalCode = postalCode;
        return _x;
    }

    @Property(name="roomDescription")
    @JsonIgnore
    public Optional<String> getRoomDescription() {
        return Optional.ofNullable(roomDescription);
    }

    public PrinterLocation withRoomDescription(String roomDescription) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.roomDescription = roomDescription;
        return _x;
    }

    @Property(name="roomName")
    @JsonIgnore
    public Optional<String> getRoomName() {
        return Optional.ofNullable(roomName);
    }

    public PrinterLocation withRoomName(String roomName) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.roomName = roomName;
        return _x;
    }

    @Property(name="roomNumber")
    @JsonIgnore
    public Optional<Integer> getRoomNumber() {
        return Optional.ofNullable(roomNumber);
    }

    public PrinterLocation withRoomNumber(Integer roomNumber) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.roomNumber = roomNumber;
        return _x;
    }

    @Property(name="site")
    @JsonIgnore
    public Optional<String> getSite() {
        return Optional.ofNullable(site);
    }

    public PrinterLocation withSite(String site) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.site = site;
        return _x;
    }

    @Property(name="stateOrProvince")
    @JsonIgnore
    public Optional<String> getStateOrProvince() {
        return Optional.ofNullable(stateOrProvince);
    }

    public PrinterLocation withStateOrProvince(String stateOrProvince) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.stateOrProvince = stateOrProvince;
        return _x;
    }

    @Property(name="streetAddress")
    @JsonIgnore
    public Optional<String> getStreetAddress() {
        return Optional.ofNullable(streetAddress);
    }

    public PrinterLocation withStreetAddress(String streetAddress) {
        PrinterLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerLocation");
        _x.streetAddress = streetAddress;
        return _x;
    }

    @Property(name="subdivision")
    @JsonIgnore
    public CollectionPage<String> getSubdivision() {
        return new CollectionPage<String>(contextPath, String.class, this.subdivision, Optional.ofNullable(subdivisionNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="subdivision")
    @JsonIgnore
    public CollectionPage<String> getSubdivision(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.subdivision, Optional.ofNullable(subdivisionNextLink), Collections.emptyList(), options);
    }

    @Property(name="subunit")
    @JsonIgnore
    public CollectionPage<String> getSubunit() {
        return new CollectionPage<String>(contextPath, String.class, this.subunit, Optional.ofNullable(subunitNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="subunit")
    @JsonIgnore
    public CollectionPage<String> getSubunit(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.subunit, Optional.ofNullable(subunitNextLink), Collections.emptyList(), options);
    }

    public PrinterLocation withUnmappedField(String name, Object value) {
        PrinterLocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer altitudeInMeters;
        private String building;
        private String city;
        private String countryOrRegion;
        private String floor;
        private String floorDescription;
        private Integer floorNumber;
        private Double latitude;
        private Double longitude;
        private List<String> organization;
        private String organizationNextLink;
        private String postalCode;
        private String roomDescription;
        private String roomName;
        private Integer roomNumber;
        private String site;
        private String stateOrProvince;
        private String streetAddress;
        private List<String> subdivision;
        private String subdivisionNextLink;
        private List<String> subunit;
        private String subunitNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder altitudeInMeters(Integer altitudeInMeters) {
            this.altitudeInMeters = altitudeInMeters;
            this.changedFields = changedFields.add("altitudeInMeters");
            return this;
        }

        public Builder building(String building) {
            this.building = building;
            this.changedFields = changedFields.add("building");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder countryOrRegion(String countryOrRegion) {
            this.countryOrRegion = countryOrRegion;
            this.changedFields = changedFields.add("countryOrRegion");
            return this;
        }

        public Builder floor(String floor) {
            this.floor = floor;
            this.changedFields = changedFields.add("floor");
            return this;
        }

        public Builder floorDescription(String floorDescription) {
            this.floorDescription = floorDescription;
            this.changedFields = changedFields.add("floorDescription");
            return this;
        }

        public Builder floorNumber(Integer floorNumber) {
            this.floorNumber = floorNumber;
            this.changedFields = changedFields.add("floorNumber");
            return this;
        }

        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            this.changedFields = changedFields.add("latitude");
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            this.changedFields = changedFields.add("longitude");
            return this;
        }

        public Builder organization(List<String> organization) {
            this.organization = organization;
            this.changedFields = changedFields.add("organization");
            return this;
        }

        public Builder organization(String... organization) {
            return organization(Arrays.asList(organization));
        }

        public Builder organizationNextLink(String organizationNextLink) {
            this.organizationNextLink = organizationNextLink;
            this.changedFields = changedFields.add("organization");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public Builder roomDescription(String roomDescription) {
            this.roomDescription = roomDescription;
            this.changedFields = changedFields.add("roomDescription");
            return this;
        }

        public Builder roomName(String roomName) {
            this.roomName = roomName;
            this.changedFields = changedFields.add("roomName");
            return this;
        }

        public Builder roomNumber(Integer roomNumber) {
            this.roomNumber = roomNumber;
            this.changedFields = changedFields.add("roomNumber");
            return this;
        }

        public Builder site(String site) {
            this.site = site;
            this.changedFields = changedFields.add("site");
            return this;
        }

        public Builder stateOrProvince(String stateOrProvince) {
            this.stateOrProvince = stateOrProvince;
            this.changedFields = changedFields.add("stateOrProvince");
            return this;
        }

        public Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            this.changedFields = changedFields.add("streetAddress");
            return this;
        }

        public Builder subdivision(List<String> subdivision) {
            this.subdivision = subdivision;
            this.changedFields = changedFields.add("subdivision");
            return this;
        }

        public Builder subdivision(String... subdivision) {
            return subdivision(Arrays.asList(subdivision));
        }

        public Builder subdivisionNextLink(String subdivisionNextLink) {
            this.subdivisionNextLink = subdivisionNextLink;
            this.changedFields = changedFields.add("subdivision");
            return this;
        }

        public Builder subunit(List<String> subunit) {
            this.subunit = subunit;
            this.changedFields = changedFields.add("subunit");
            return this;
        }

        public Builder subunit(String... subunit) {
            return subunit(Arrays.asList(subunit));
        }

        public Builder subunitNextLink(String subunitNextLink) {
            this.subunitNextLink = subunitNextLink;
            this.changedFields = changedFields.add("subunit");
            return this;
        }

        public PrinterLocation build() {
            PrinterLocation _x = new PrinterLocation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printerLocation";
            _x.altitudeInMeters = altitudeInMeters;
            _x.building = building;
            _x.city = city;
            _x.countryOrRegion = countryOrRegion;
            _x.floor = floor;
            _x.floorDescription = floorDescription;
            _x.floorNumber = floorNumber;
            _x.latitude = latitude;
            _x.longitude = longitude;
            _x.organization = organization;
            _x.organizationNextLink = organizationNextLink;
            _x.postalCode = postalCode;
            _x.roomDescription = roomDescription;
            _x.roomName = roomName;
            _x.roomNumber = roomNumber;
            _x.site = site;
            _x.stateOrProvince = stateOrProvince;
            _x.streetAddress = streetAddress;
            _x.subdivision = subdivision;
            _x.subdivisionNextLink = subdivisionNextLink;
            _x.subunit = subunit;
            _x.subunitNextLink = subunitNextLink;
            return _x;
        }
    }

    private PrinterLocation _copy() {
        PrinterLocation _x = new PrinterLocation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.altitudeInMeters = altitudeInMeters;
        _x.building = building;
        _x.city = city;
        _x.countryOrRegion = countryOrRegion;
        _x.floor = floor;
        _x.floorDescription = floorDescription;
        _x.floorNumber = floorNumber;
        _x.latitude = latitude;
        _x.longitude = longitude;
        _x.organization = organization;
        _x.postalCode = postalCode;
        _x.roomDescription = roomDescription;
        _x.roomName = roomName;
        _x.roomNumber = roomNumber;
        _x.site = site;
        _x.stateOrProvince = stateOrProvince;
        _x.streetAddress = streetAddress;
        _x.subdivision = subdivision;
        _x.subunit = subunit;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterLocation[");
        b.append("altitudeInMeters=");
        b.append(this.altitudeInMeters);
        b.append(", ");
        b.append("building=");
        b.append(this.building);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("countryOrRegion=");
        b.append(this.countryOrRegion);
        b.append(", ");
        b.append("floor=");
        b.append(this.floor);
        b.append(", ");
        b.append("floorDescription=");
        b.append(this.floorDescription);
        b.append(", ");
        b.append("floorNumber=");
        b.append(this.floorNumber);
        b.append(", ");
        b.append("latitude=");
        b.append(this.latitude);
        b.append(", ");
        b.append("longitude=");
        b.append(this.longitude);
        b.append(", ");
        b.append("organization=");
        b.append(this.organization);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append(", ");
        b.append("roomDescription=");
        b.append(this.roomDescription);
        b.append(", ");
        b.append("roomName=");
        b.append(this.roomName);
        b.append(", ");
        b.append("roomNumber=");
        b.append(this.roomNumber);
        b.append(", ");
        b.append("site=");
        b.append(this.site);
        b.append(", ");
        b.append("stateOrProvince=");
        b.append(this.stateOrProvince);
        b.append(", ");
        b.append("streetAddress=");
        b.append(this.streetAddress);
        b.append(", ");
        b.append("subdivision=");
        b.append(this.subdivision);
        b.append(", ");
        b.append("subunit=");
        b.append(this.subunit);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
