package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintColorConfiguration;
import odata.msgraph.client.beta.enums.PrintColorMode;
import odata.msgraph.client.beta.enums.PrintDuplexConfiguration;
import odata.msgraph.client.beta.enums.PrintDuplexMode;
import odata.msgraph.client.beta.enums.PrintFinishing;
import odata.msgraph.client.beta.enums.PrintMultipageLayout;
import odata.msgraph.client.beta.enums.PrintOrientation;
import odata.msgraph.client.beta.enums.PrintPresentationDirection;
import odata.msgraph.client.beta.enums.PrintQuality;
import odata.msgraph.client.beta.enums.PrintScaling;

@JsonPropertyOrder({
    "@odata.type", 
    "colorMode", 
    "contentType", 
    "copiesPerJob", 
    "documentMimeType", 
    "dpi", 
    "duplexConfiguration", 
    "duplexMode", 
    "finishings", 
    "fitPdfToPage", 
    "inputBin", 
    "mediaColor", 
    "mediaSize", 
    "mediaType", 
    "multipageLayout", 
    "orientation", 
    "outputBin", 
    "pagesPerSheet", 
    "pdfFitToPage", 
    "presentationDirection", 
    "printColorConfiguration", 
    "printQuality", 
    "quality", 
    "scaling"})
@JsonInclude(Include.NON_NULL)
public class PrinterDefaults implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("colorMode")
    protected PrintColorMode colorMode;

    @JsonProperty("contentType")
    protected String contentType;

    @JsonProperty("copiesPerJob")
    protected Integer copiesPerJob;

    @JsonProperty("documentMimeType")
    protected String documentMimeType;

    @JsonProperty("dpi")
    protected Integer dpi;

    @JsonProperty("duplexConfiguration")
    protected PrintDuplexConfiguration duplexConfiguration;

    @JsonProperty("duplexMode")
    protected PrintDuplexMode duplexMode;

    @JsonProperty("finishings")
    protected List<PrintFinishing> finishings;

    @JsonProperty("finishings@nextLink")
    protected String finishingsNextLink;

    @JsonProperty("fitPdfToPage")
    protected Boolean fitPdfToPage;

    @JsonProperty("inputBin")
    protected String inputBin;

    @JsonProperty("mediaColor")
    protected String mediaColor;

    @JsonProperty("mediaSize")
    protected String mediaSize;

    @JsonProperty("mediaType")
    protected String mediaType;

    @JsonProperty("multipageLayout")
    protected PrintMultipageLayout multipageLayout;

    @JsonProperty("orientation")
    protected PrintOrientation orientation;

    @JsonProperty("outputBin")
    protected String outputBin;

    @JsonProperty("pagesPerSheet")
    protected Integer pagesPerSheet;

    @JsonProperty("pdfFitToPage")
    protected Boolean pdfFitToPage;

    @JsonProperty("presentationDirection")
    protected PrintPresentationDirection presentationDirection;

    @JsonProperty("printColorConfiguration")
    protected PrintColorConfiguration printColorConfiguration;

    @JsonProperty("printQuality")
    protected PrintQuality printQuality;

    @JsonProperty("quality")
    protected PrintQuality quality;

    @JsonProperty("scaling")
    protected PrintScaling scaling;

    protected PrinterDefaults() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerDefaults";
    }

    @Property(name="colorMode")
    @JsonIgnore
    public Optional<PrintColorMode> getColorMode() {
        return Optional.ofNullable(colorMode);
    }

    public PrinterDefaults withColorMode(PrintColorMode colorMode) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.colorMode = colorMode;
        return _x;
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public PrinterDefaults withContentType(String contentType) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="copiesPerJob")
    @JsonIgnore
    public Optional<Integer> getCopiesPerJob() {
        return Optional.ofNullable(copiesPerJob);
    }

    public PrinterDefaults withCopiesPerJob(Integer copiesPerJob) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.copiesPerJob = copiesPerJob;
        return _x;
    }

    @Property(name="documentMimeType")
    @JsonIgnore
    public Optional<String> getDocumentMimeType() {
        return Optional.ofNullable(documentMimeType);
    }

    public PrinterDefaults withDocumentMimeType(String documentMimeType) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.documentMimeType = documentMimeType;
        return _x;
    }

    @Property(name="dpi")
    @JsonIgnore
    public Optional<Integer> getDpi() {
        return Optional.ofNullable(dpi);
    }

    public PrinterDefaults withDpi(Integer dpi) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.dpi = dpi;
        return _x;
    }

    @Property(name="duplexConfiguration")
    @JsonIgnore
    public Optional<PrintDuplexConfiguration> getDuplexConfiguration() {
        return Optional.ofNullable(duplexConfiguration);
    }

    public PrinterDefaults withDuplexConfiguration(PrintDuplexConfiguration duplexConfiguration) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.duplexConfiguration = duplexConfiguration;
        return _x;
    }

    @Property(name="duplexMode")
    @JsonIgnore
    public Optional<PrintDuplexMode> getDuplexMode() {
        return Optional.ofNullable(duplexMode);
    }

    public PrinterDefaults withDuplexMode(PrintDuplexMode duplexMode) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.duplexMode = duplexMode;
        return _x;
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings() {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.finishings, Optional.ofNullable(finishingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings(HttpRequestOptions options) {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.finishings, Optional.ofNullable(finishingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="fitPdfToPage")
    @JsonIgnore
    public Optional<Boolean> getFitPdfToPage() {
        return Optional.ofNullable(fitPdfToPage);
    }

    public PrinterDefaults withFitPdfToPage(Boolean fitPdfToPage) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.fitPdfToPage = fitPdfToPage;
        return _x;
    }

    @Property(name="inputBin")
    @JsonIgnore
    public Optional<String> getInputBin() {
        return Optional.ofNullable(inputBin);
    }

    public PrinterDefaults withInputBin(String inputBin) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.inputBin = inputBin;
        return _x;
    }

    @Property(name="mediaColor")
    @JsonIgnore
    public Optional<String> getMediaColor() {
        return Optional.ofNullable(mediaColor);
    }

    public PrinterDefaults withMediaColor(String mediaColor) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.mediaColor = mediaColor;
        return _x;
    }

    @Property(name="mediaSize")
    @JsonIgnore
    public Optional<String> getMediaSize() {
        return Optional.ofNullable(mediaSize);
    }

    public PrinterDefaults withMediaSize(String mediaSize) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.mediaSize = mediaSize;
        return _x;
    }

    @Property(name="mediaType")
    @JsonIgnore
    public Optional<String> getMediaType() {
        return Optional.ofNullable(mediaType);
    }

    public PrinterDefaults withMediaType(String mediaType) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.mediaType = mediaType;
        return _x;
    }

    @Property(name="multipageLayout")
    @JsonIgnore
    public Optional<PrintMultipageLayout> getMultipageLayout() {
        return Optional.ofNullable(multipageLayout);
    }

    public PrinterDefaults withMultipageLayout(PrintMultipageLayout multipageLayout) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.multipageLayout = multipageLayout;
        return _x;
    }

    @Property(name="orientation")
    @JsonIgnore
    public Optional<PrintOrientation> getOrientation() {
        return Optional.ofNullable(orientation);
    }

    public PrinterDefaults withOrientation(PrintOrientation orientation) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.orientation = orientation;
        return _x;
    }

    @Property(name="outputBin")
    @JsonIgnore
    public Optional<String> getOutputBin() {
        return Optional.ofNullable(outputBin);
    }

    public PrinterDefaults withOutputBin(String outputBin) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.outputBin = outputBin;
        return _x;
    }

    @Property(name="pagesPerSheet")
    @JsonIgnore
    public Optional<Integer> getPagesPerSheet() {
        return Optional.ofNullable(pagesPerSheet);
    }

    public PrinterDefaults withPagesPerSheet(Integer pagesPerSheet) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.pagesPerSheet = pagesPerSheet;
        return _x;
    }

    @Property(name="pdfFitToPage")
    @JsonIgnore
    public Optional<Boolean> getPdfFitToPage() {
        return Optional.ofNullable(pdfFitToPage);
    }

    public PrinterDefaults withPdfFitToPage(Boolean pdfFitToPage) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.pdfFitToPage = pdfFitToPage;
        return _x;
    }

    @Property(name="presentationDirection")
    @JsonIgnore
    public Optional<PrintPresentationDirection> getPresentationDirection() {
        return Optional.ofNullable(presentationDirection);
    }

    public PrinterDefaults withPresentationDirection(PrintPresentationDirection presentationDirection) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.presentationDirection = presentationDirection;
        return _x;
    }

    @Property(name="printColorConfiguration")
    @JsonIgnore
    public Optional<PrintColorConfiguration> getPrintColorConfiguration() {
        return Optional.ofNullable(printColorConfiguration);
    }

    public PrinterDefaults withPrintColorConfiguration(PrintColorConfiguration printColorConfiguration) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.printColorConfiguration = printColorConfiguration;
        return _x;
    }

    @Property(name="printQuality")
    @JsonIgnore
    public Optional<PrintQuality> getPrintQuality() {
        return Optional.ofNullable(printQuality);
    }

    public PrinterDefaults withPrintQuality(PrintQuality printQuality) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.printQuality = printQuality;
        return _x;
    }

    @Property(name="quality")
    @JsonIgnore
    public Optional<PrintQuality> getQuality() {
        return Optional.ofNullable(quality);
    }

    public PrinterDefaults withQuality(PrintQuality quality) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.quality = quality;
        return _x;
    }

    @Property(name="scaling")
    @JsonIgnore
    public Optional<PrintScaling> getScaling() {
        return Optional.ofNullable(scaling);
    }

    public PrinterDefaults withScaling(PrintScaling scaling) {
        PrinterDefaults _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerDefaults");
        _x.scaling = scaling;
        return _x;
    }

    public PrinterDefaults withUnmappedField(String name, Object value) {
        PrinterDefaults _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PrintColorMode colorMode;
        private String contentType;
        private Integer copiesPerJob;
        private String documentMimeType;
        private Integer dpi;
        private PrintDuplexConfiguration duplexConfiguration;
        private PrintDuplexMode duplexMode;
        private List<PrintFinishing> finishings;
        private String finishingsNextLink;
        private Boolean fitPdfToPage;
        private String inputBin;
        private String mediaColor;
        private String mediaSize;
        private String mediaType;
        private PrintMultipageLayout multipageLayout;
        private PrintOrientation orientation;
        private String outputBin;
        private Integer pagesPerSheet;
        private Boolean pdfFitToPage;
        private PrintPresentationDirection presentationDirection;
        private PrintColorConfiguration printColorConfiguration;
        private PrintQuality printQuality;
        private PrintQuality quality;
        private PrintScaling scaling;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder colorMode(PrintColorMode colorMode) {
            this.colorMode = colorMode;
            this.changedFields = changedFields.add("colorMode");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder copiesPerJob(Integer copiesPerJob) {
            this.copiesPerJob = copiesPerJob;
            this.changedFields = changedFields.add("copiesPerJob");
            return this;
        }

        public Builder documentMimeType(String documentMimeType) {
            this.documentMimeType = documentMimeType;
            this.changedFields = changedFields.add("documentMimeType");
            return this;
        }

        public Builder dpi(Integer dpi) {
            this.dpi = dpi;
            this.changedFields = changedFields.add("dpi");
            return this;
        }

        public Builder duplexConfiguration(PrintDuplexConfiguration duplexConfiguration) {
            this.duplexConfiguration = duplexConfiguration;
            this.changedFields = changedFields.add("duplexConfiguration");
            return this;
        }

        public Builder duplexMode(PrintDuplexMode duplexMode) {
            this.duplexMode = duplexMode;
            this.changedFields = changedFields.add("duplexMode");
            return this;
        }

        public Builder finishings(List<PrintFinishing> finishings) {
            this.finishings = finishings;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder finishings(PrintFinishing... finishings) {
            return finishings(Arrays.asList(finishings));
        }

        public Builder finishingsNextLink(String finishingsNextLink) {
            this.finishingsNextLink = finishingsNextLink;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder fitPdfToPage(Boolean fitPdfToPage) {
            this.fitPdfToPage = fitPdfToPage;
            this.changedFields = changedFields.add("fitPdfToPage");
            return this;
        }

        public Builder inputBin(String inputBin) {
            this.inputBin = inputBin;
            this.changedFields = changedFields.add("inputBin");
            return this;
        }

        public Builder mediaColor(String mediaColor) {
            this.mediaColor = mediaColor;
            this.changedFields = changedFields.add("mediaColor");
            return this;
        }

        public Builder mediaSize(String mediaSize) {
            this.mediaSize = mediaSize;
            this.changedFields = changedFields.add("mediaSize");
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            this.changedFields = changedFields.add("mediaType");
            return this;
        }

        public Builder multipageLayout(PrintMultipageLayout multipageLayout) {
            this.multipageLayout = multipageLayout;
            this.changedFields = changedFields.add("multipageLayout");
            return this;
        }

        public Builder orientation(PrintOrientation orientation) {
            this.orientation = orientation;
            this.changedFields = changedFields.add("orientation");
            return this;
        }

        public Builder outputBin(String outputBin) {
            this.outputBin = outputBin;
            this.changedFields = changedFields.add("outputBin");
            return this;
        }

        public Builder pagesPerSheet(Integer pagesPerSheet) {
            this.pagesPerSheet = pagesPerSheet;
            this.changedFields = changedFields.add("pagesPerSheet");
            return this;
        }

        public Builder pdfFitToPage(Boolean pdfFitToPage) {
            this.pdfFitToPage = pdfFitToPage;
            this.changedFields = changedFields.add("pdfFitToPage");
            return this;
        }

        public Builder presentationDirection(PrintPresentationDirection presentationDirection) {
            this.presentationDirection = presentationDirection;
            this.changedFields = changedFields.add("presentationDirection");
            return this;
        }

        public Builder printColorConfiguration(PrintColorConfiguration printColorConfiguration) {
            this.printColorConfiguration = printColorConfiguration;
            this.changedFields = changedFields.add("printColorConfiguration");
            return this;
        }

        public Builder printQuality(PrintQuality printQuality) {
            this.printQuality = printQuality;
            this.changedFields = changedFields.add("printQuality");
            return this;
        }

        public Builder quality(PrintQuality quality) {
            this.quality = quality;
            this.changedFields = changedFields.add("quality");
            return this;
        }

        public Builder scaling(PrintScaling scaling) {
            this.scaling = scaling;
            this.changedFields = changedFields.add("scaling");
            return this;
        }

        public PrinterDefaults build() {
            PrinterDefaults _x = new PrinterDefaults();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printerDefaults";
            _x.colorMode = colorMode;
            _x.contentType = contentType;
            _x.copiesPerJob = copiesPerJob;
            _x.documentMimeType = documentMimeType;
            _x.dpi = dpi;
            _x.duplexConfiguration = duplexConfiguration;
            _x.duplexMode = duplexMode;
            _x.finishings = finishings;
            _x.finishingsNextLink = finishingsNextLink;
            _x.fitPdfToPage = fitPdfToPage;
            _x.inputBin = inputBin;
            _x.mediaColor = mediaColor;
            _x.mediaSize = mediaSize;
            _x.mediaType = mediaType;
            _x.multipageLayout = multipageLayout;
            _x.orientation = orientation;
            _x.outputBin = outputBin;
            _x.pagesPerSheet = pagesPerSheet;
            _x.pdfFitToPage = pdfFitToPage;
            _x.presentationDirection = presentationDirection;
            _x.printColorConfiguration = printColorConfiguration;
            _x.printQuality = printQuality;
            _x.quality = quality;
            _x.scaling = scaling;
            return _x;
        }
    }

    private PrinterDefaults _copy() {
        PrinterDefaults _x = new PrinterDefaults();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.colorMode = colorMode;
        _x.contentType = contentType;
        _x.copiesPerJob = copiesPerJob;
        _x.documentMimeType = documentMimeType;
        _x.dpi = dpi;
        _x.duplexConfiguration = duplexConfiguration;
        _x.duplexMode = duplexMode;
        _x.finishings = finishings;
        _x.fitPdfToPage = fitPdfToPage;
        _x.inputBin = inputBin;
        _x.mediaColor = mediaColor;
        _x.mediaSize = mediaSize;
        _x.mediaType = mediaType;
        _x.multipageLayout = multipageLayout;
        _x.orientation = orientation;
        _x.outputBin = outputBin;
        _x.pagesPerSheet = pagesPerSheet;
        _x.pdfFitToPage = pdfFitToPage;
        _x.presentationDirection = presentationDirection;
        _x.printColorConfiguration = printColorConfiguration;
        _x.printQuality = printQuality;
        _x.quality = quality;
        _x.scaling = scaling;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterDefaults[");
        b.append("colorMode=");
        b.append(this.colorMode);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("copiesPerJob=");
        b.append(this.copiesPerJob);
        b.append(", ");
        b.append("documentMimeType=");
        b.append(this.documentMimeType);
        b.append(", ");
        b.append("dpi=");
        b.append(this.dpi);
        b.append(", ");
        b.append("duplexConfiguration=");
        b.append(this.duplexConfiguration);
        b.append(", ");
        b.append("duplexMode=");
        b.append(this.duplexMode);
        b.append(", ");
        b.append("finishings=");
        b.append(this.finishings);
        b.append(", ");
        b.append("fitPdfToPage=");
        b.append(this.fitPdfToPage);
        b.append(", ");
        b.append("inputBin=");
        b.append(this.inputBin);
        b.append(", ");
        b.append("mediaColor=");
        b.append(this.mediaColor);
        b.append(", ");
        b.append("mediaSize=");
        b.append(this.mediaSize);
        b.append(", ");
        b.append("mediaType=");
        b.append(this.mediaType);
        b.append(", ");
        b.append("multipageLayout=");
        b.append(this.multipageLayout);
        b.append(", ");
        b.append("orientation=");
        b.append(this.orientation);
        b.append(", ");
        b.append("outputBin=");
        b.append(this.outputBin);
        b.append(", ");
        b.append("pagesPerSheet=");
        b.append(this.pagesPerSheet);
        b.append(", ");
        b.append("pdfFitToPage=");
        b.append(this.pdfFitToPage);
        b.append(", ");
        b.append("presentationDirection=");
        b.append(this.presentationDirection);
        b.append(", ");
        b.append("printColorConfiguration=");
        b.append(this.printColorConfiguration);
        b.append(", ");
        b.append("printQuality=");
        b.append(this.printQuality);
        b.append(", ");
        b.append("quality=");
        b.append(this.quality);
        b.append(", ");
        b.append("scaling=");
        b.append(this.scaling);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
