package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintColorConfiguration;
import odata.msgraph.client.beta.enums.PrintColorMode;
import odata.msgraph.client.beta.enums.PrintDuplexConfiguration;
import odata.msgraph.client.beta.enums.PrintDuplexMode;
import odata.msgraph.client.beta.enums.PrintFinishing;
import odata.msgraph.client.beta.enums.PrintMediaType;
import odata.msgraph.client.beta.enums.PrintMultipageLayout;
import odata.msgraph.client.beta.enums.PrintOrientation;
import odata.msgraph.client.beta.enums.PrintPresentationDirection;
import odata.msgraph.client.beta.enums.PrintQuality;
import odata.msgraph.client.beta.enums.PrintScaling;
import odata.msgraph.client.beta.enums.PrinterFeedDirection;
import odata.msgraph.client.beta.enums.PrinterFeedOrientation;

@JsonPropertyOrder({
    "@odata.type", 
    "bottomMargins", 
    "collation", 
    "colorModes", 
    "contentTypes", 
    "copiesPerJob", 
    "dpis", 
    "duplexModes", 
    "feedDirections", 
    "feedOrientations", 
    "finishings", 
    "inputBins", 
    "isColorPrintingSupported", 
    "isPageRangeSupported", 
    "leftMargins", 
    "mediaColors", 
    "mediaSizes", 
    "mediaTypes", 
    "multipageLayouts", 
    "orientations", 
    "outputBins", 
    "pagesPerSheet", 
    "qualities", 
    "rightMargins", 
    "scalings", 
    "supportedColorConfigurations", 
    "supportedCopiesPerJob", 
    "supportedDocumentMimeTypes", 
    "supportedDuplexConfigurations", 
    "supportedFinishings", 
    "supportedMediaColors", 
    "supportedMediaSizes", 
    "supportedMediaTypes", 
    "supportedOrientations", 
    "supportedOutputBins", 
    "supportedPagesPerSheet", 
    "supportedPresentationDirections", 
    "supportedPrintQualities", 
    "supportsFitPdfToPage", 
    "topMargins"})
@JsonInclude(Include.NON_NULL)
public class PrinterCapabilities implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bottomMargins")
    protected List<Integer> bottomMargins;

    @JsonProperty("bottomMargins@nextLink")
    protected String bottomMarginsNextLink;

    @JsonProperty("collation")
    protected Boolean collation;

    @JsonProperty("colorModes")
    protected List<PrintColorMode> colorModes;

    @JsonProperty("colorModes@nextLink")
    protected String colorModesNextLink;

    @JsonProperty("contentTypes")
    protected List<String> contentTypes;

    @JsonProperty("contentTypes@nextLink")
    protected String contentTypesNextLink;

    @JsonProperty("copiesPerJob")
    protected IntegerRange copiesPerJob;

    @JsonProperty("dpis")
    protected List<Integer> dpis;

    @JsonProperty("dpis@nextLink")
    protected String dpisNextLink;

    @JsonProperty("duplexModes")
    protected List<PrintDuplexMode> duplexModes;

    @JsonProperty("duplexModes@nextLink")
    protected String duplexModesNextLink;

    @JsonProperty("feedDirections")
    protected List<PrinterFeedDirection> feedDirections;

    @JsonProperty("feedDirections@nextLink")
    protected String feedDirectionsNextLink;

    @JsonProperty("feedOrientations")
    protected List<PrinterFeedOrientation> feedOrientations;

    @JsonProperty("feedOrientations@nextLink")
    protected String feedOrientationsNextLink;

    @JsonProperty("finishings")
    protected List<PrintFinishing> finishings;

    @JsonProperty("finishings@nextLink")
    protected String finishingsNextLink;

    @JsonProperty("inputBins")
    protected List<String> inputBins;

    @JsonProperty("inputBins@nextLink")
    protected String inputBinsNextLink;

    @JsonProperty("isColorPrintingSupported")
    protected Boolean isColorPrintingSupported;

    @JsonProperty("isPageRangeSupported")
    protected Boolean isPageRangeSupported;

    @JsonProperty("leftMargins")
    protected List<Integer> leftMargins;

    @JsonProperty("leftMargins@nextLink")
    protected String leftMarginsNextLink;

    @JsonProperty("mediaColors")
    protected List<String> mediaColors;

    @JsonProperty("mediaColors@nextLink")
    protected String mediaColorsNextLink;

    @JsonProperty("mediaSizes")
    protected List<String> mediaSizes;

    @JsonProperty("mediaSizes@nextLink")
    protected String mediaSizesNextLink;

    @JsonProperty("mediaTypes")
    protected List<String> mediaTypes;

    @JsonProperty("mediaTypes@nextLink")
    protected String mediaTypesNextLink;

    @JsonProperty("multipageLayouts")
    protected List<PrintMultipageLayout> multipageLayouts;

    @JsonProperty("multipageLayouts@nextLink")
    protected String multipageLayoutsNextLink;

    @JsonProperty("orientations")
    protected List<PrintOrientation> orientations;

    @JsonProperty("orientations@nextLink")
    protected String orientationsNextLink;

    @JsonProperty("outputBins")
    protected List<String> outputBins;

    @JsonProperty("outputBins@nextLink")
    protected String outputBinsNextLink;

    @JsonProperty("pagesPerSheet")
    protected List<Integer> pagesPerSheet;

    @JsonProperty("pagesPerSheet@nextLink")
    protected String pagesPerSheetNextLink;

    @JsonProperty("qualities")
    protected List<PrintQuality> qualities;

    @JsonProperty("qualities@nextLink")
    protected String qualitiesNextLink;

    @JsonProperty("rightMargins")
    protected List<Integer> rightMargins;

    @JsonProperty("rightMargins@nextLink")
    protected String rightMarginsNextLink;

    @JsonProperty("scalings")
    protected List<PrintScaling> scalings;

    @JsonProperty("scalings@nextLink")
    protected String scalingsNextLink;

    @JsonProperty("supportedColorConfigurations")
    protected List<PrintColorConfiguration> supportedColorConfigurations;

    @JsonProperty("supportedColorConfigurations@nextLink")
    protected String supportedColorConfigurationsNextLink;

    @JsonProperty("supportedCopiesPerJob")
    protected IntegerRange supportedCopiesPerJob;

    @JsonProperty("supportedDocumentMimeTypes")
    protected List<String> supportedDocumentMimeTypes;

    @JsonProperty("supportedDocumentMimeTypes@nextLink")
    protected String supportedDocumentMimeTypesNextLink;

    @JsonProperty("supportedDuplexConfigurations")
    protected List<PrintDuplexConfiguration> supportedDuplexConfigurations;

    @JsonProperty("supportedDuplexConfigurations@nextLink")
    protected String supportedDuplexConfigurationsNextLink;

    @JsonProperty("supportedFinishings")
    protected List<PrintFinishing> supportedFinishings;

    @JsonProperty("supportedFinishings@nextLink")
    protected String supportedFinishingsNextLink;

    @JsonProperty("supportedMediaColors")
    protected List<String> supportedMediaColors;

    @JsonProperty("supportedMediaColors@nextLink")
    protected String supportedMediaColorsNextLink;

    @JsonProperty("supportedMediaSizes")
    protected List<String> supportedMediaSizes;

    @JsonProperty("supportedMediaSizes@nextLink")
    protected String supportedMediaSizesNextLink;

    @JsonProperty("supportedMediaTypes")
    protected List<PrintMediaType> supportedMediaTypes;

    @JsonProperty("supportedMediaTypes@nextLink")
    protected String supportedMediaTypesNextLink;

    @JsonProperty("supportedOrientations")
    protected List<PrintOrientation> supportedOrientations;

    @JsonProperty("supportedOrientations@nextLink")
    protected String supportedOrientationsNextLink;

    @JsonProperty("supportedOutputBins")
    protected List<String> supportedOutputBins;

    @JsonProperty("supportedOutputBins@nextLink")
    protected String supportedOutputBinsNextLink;

    @JsonProperty("supportedPagesPerSheet")
    protected IntegerRange supportedPagesPerSheet;

    @JsonProperty("supportedPresentationDirections")
    protected List<PrintPresentationDirection> supportedPresentationDirections;

    @JsonProperty("supportedPresentationDirections@nextLink")
    protected String supportedPresentationDirectionsNextLink;

    @JsonProperty("supportedPrintQualities")
    protected List<PrintQuality> supportedPrintQualities;

    @JsonProperty("supportedPrintQualities@nextLink")
    protected String supportedPrintQualitiesNextLink;

    @JsonProperty("supportsFitPdfToPage")
    protected Boolean supportsFitPdfToPage;

    @JsonProperty("topMargins")
    protected List<Integer> topMargins;

    @JsonProperty("topMargins@nextLink")
    protected String topMarginsNextLink;

    protected PrinterCapabilities() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printerCapabilities";
    }

    @Property(name="bottomMargins")
    @JsonIgnore
    public CollectionPage<Integer> getBottomMargins() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.bottomMargins, Optional.ofNullable(bottomMarginsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="bottomMargins")
    @JsonIgnore
    public CollectionPage<Integer> getBottomMargins(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.bottomMargins, Optional.ofNullable(bottomMarginsNextLink), Collections.emptyList(), options);
    }

    @Property(name="collation")
    @JsonIgnore
    public Optional<Boolean> getCollation() {
        return Optional.ofNullable(collation);
    }

    public PrinterCapabilities withCollation(Boolean collation) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.collation = collation;
        return _x;
    }

    @Property(name="colorModes")
    @JsonIgnore
    public CollectionPage<PrintColorMode> getColorModes() {
        return new CollectionPage<PrintColorMode>(contextPath, PrintColorMode.class, this.colorModes, Optional.ofNullable(colorModesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="colorModes")
    @JsonIgnore
    public CollectionPage<PrintColorMode> getColorModes(HttpRequestOptions options) {
        return new CollectionPage<PrintColorMode>(contextPath, PrintColorMode.class, this.colorModes, Optional.ofNullable(colorModesNextLink), Collections.emptyList(), options);
    }

    @Property(name="contentTypes")
    @JsonIgnore
    public CollectionPage<String> getContentTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.contentTypes, Optional.ofNullable(contentTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="contentTypes")
    @JsonIgnore
    public CollectionPage<String> getContentTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.contentTypes, Optional.ofNullable(contentTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="copiesPerJob")
    @JsonIgnore
    public Optional<IntegerRange> getCopiesPerJob() {
        return Optional.ofNullable(copiesPerJob);
    }

    public PrinterCapabilities withCopiesPerJob(IntegerRange copiesPerJob) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.copiesPerJob = copiesPerJob;
        return _x;
    }

    @Property(name="dpis")
    @JsonIgnore
    public CollectionPage<Integer> getDpis() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.dpis, Optional.ofNullable(dpisNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="dpis")
    @JsonIgnore
    public CollectionPage<Integer> getDpis(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.dpis, Optional.ofNullable(dpisNextLink), Collections.emptyList(), options);
    }

    @Property(name="duplexModes")
    @JsonIgnore
    public CollectionPage<PrintDuplexMode> getDuplexModes() {
        return new CollectionPage<PrintDuplexMode>(contextPath, PrintDuplexMode.class, this.duplexModes, Optional.ofNullable(duplexModesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="duplexModes")
    @JsonIgnore
    public CollectionPage<PrintDuplexMode> getDuplexModes(HttpRequestOptions options) {
        return new CollectionPage<PrintDuplexMode>(contextPath, PrintDuplexMode.class, this.duplexModes, Optional.ofNullable(duplexModesNextLink), Collections.emptyList(), options);
    }

    @Property(name="feedDirections")
    @JsonIgnore
    public CollectionPage<PrinterFeedDirection> getFeedDirections() {
        return new CollectionPage<PrinterFeedDirection>(contextPath, PrinterFeedDirection.class, this.feedDirections, Optional.ofNullable(feedDirectionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="feedDirections")
    @JsonIgnore
    public CollectionPage<PrinterFeedDirection> getFeedDirections(HttpRequestOptions options) {
        return new CollectionPage<PrinterFeedDirection>(contextPath, PrinterFeedDirection.class, this.feedDirections, Optional.ofNullable(feedDirectionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="feedOrientations")
    @JsonIgnore
    public CollectionPage<PrinterFeedOrientation> getFeedOrientations() {
        return new CollectionPage<PrinterFeedOrientation>(contextPath, PrinterFeedOrientation.class, this.feedOrientations, Optional.ofNullable(feedOrientationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="feedOrientations")
    @JsonIgnore
    public CollectionPage<PrinterFeedOrientation> getFeedOrientations(HttpRequestOptions options) {
        return new CollectionPage<PrinterFeedOrientation>(contextPath, PrinterFeedOrientation.class, this.feedOrientations, Optional.ofNullable(feedOrientationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings() {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.finishings, Optional.ofNullable(finishingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="finishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getFinishings(HttpRequestOptions options) {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.finishings, Optional.ofNullable(finishingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="inputBins")
    @JsonIgnore
    public CollectionPage<String> getInputBins() {
        return new CollectionPage<String>(contextPath, String.class, this.inputBins, Optional.ofNullable(inputBinsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="inputBins")
    @JsonIgnore
    public CollectionPage<String> getInputBins(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.inputBins, Optional.ofNullable(inputBinsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isColorPrintingSupported")
    @JsonIgnore
    public Optional<Boolean> getIsColorPrintingSupported() {
        return Optional.ofNullable(isColorPrintingSupported);
    }

    public PrinterCapabilities withIsColorPrintingSupported(Boolean isColorPrintingSupported) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.isColorPrintingSupported = isColorPrintingSupported;
        return _x;
    }

    @Property(name="isPageRangeSupported")
    @JsonIgnore
    public Optional<Boolean> getIsPageRangeSupported() {
        return Optional.ofNullable(isPageRangeSupported);
    }

    public PrinterCapabilities withIsPageRangeSupported(Boolean isPageRangeSupported) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.isPageRangeSupported = isPageRangeSupported;
        return _x;
    }

    @Property(name="leftMargins")
    @JsonIgnore
    public CollectionPage<Integer> getLeftMargins() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.leftMargins, Optional.ofNullable(leftMarginsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="leftMargins")
    @JsonIgnore
    public CollectionPage<Integer> getLeftMargins(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.leftMargins, Optional.ofNullable(leftMarginsNextLink), Collections.emptyList(), options);
    }

    @Property(name="mediaColors")
    @JsonIgnore
    public CollectionPage<String> getMediaColors() {
        return new CollectionPage<String>(contextPath, String.class, this.mediaColors, Optional.ofNullable(mediaColorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mediaColors")
    @JsonIgnore
    public CollectionPage<String> getMediaColors(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.mediaColors, Optional.ofNullable(mediaColorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="mediaSizes")
    @JsonIgnore
    public CollectionPage<String> getMediaSizes() {
        return new CollectionPage<String>(contextPath, String.class, this.mediaSizes, Optional.ofNullable(mediaSizesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mediaSizes")
    @JsonIgnore
    public CollectionPage<String> getMediaSizes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.mediaSizes, Optional.ofNullable(mediaSizesNextLink), Collections.emptyList(), options);
    }

    @Property(name="mediaTypes")
    @JsonIgnore
    public CollectionPage<String> getMediaTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.mediaTypes, Optional.ofNullable(mediaTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mediaTypes")
    @JsonIgnore
    public CollectionPage<String> getMediaTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.mediaTypes, Optional.ofNullable(mediaTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="multipageLayouts")
    @JsonIgnore
    public CollectionPage<PrintMultipageLayout> getMultipageLayouts() {
        return new CollectionPage<PrintMultipageLayout>(contextPath, PrintMultipageLayout.class, this.multipageLayouts, Optional.ofNullable(multipageLayoutsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="multipageLayouts")
    @JsonIgnore
    public CollectionPage<PrintMultipageLayout> getMultipageLayouts(HttpRequestOptions options) {
        return new CollectionPage<PrintMultipageLayout>(contextPath, PrintMultipageLayout.class, this.multipageLayouts, Optional.ofNullable(multipageLayoutsNextLink), Collections.emptyList(), options);
    }

    @Property(name="orientations")
    @JsonIgnore
    public CollectionPage<PrintOrientation> getOrientations() {
        return new CollectionPage<PrintOrientation>(contextPath, PrintOrientation.class, this.orientations, Optional.ofNullable(orientationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="orientations")
    @JsonIgnore
    public CollectionPage<PrintOrientation> getOrientations(HttpRequestOptions options) {
        return new CollectionPage<PrintOrientation>(contextPath, PrintOrientation.class, this.orientations, Optional.ofNullable(orientationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="outputBins")
    @JsonIgnore
    public CollectionPage<String> getOutputBins() {
        return new CollectionPage<String>(contextPath, String.class, this.outputBins, Optional.ofNullable(outputBinsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="outputBins")
    @JsonIgnore
    public CollectionPage<String> getOutputBins(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.outputBins, Optional.ofNullable(outputBinsNextLink), Collections.emptyList(), options);
    }

    @Property(name="pagesPerSheet")
    @JsonIgnore
    public CollectionPage<Integer> getPagesPerSheet() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.pagesPerSheet, Optional.ofNullable(pagesPerSheetNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="pagesPerSheet")
    @JsonIgnore
    public CollectionPage<Integer> getPagesPerSheet(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.pagesPerSheet, Optional.ofNullable(pagesPerSheetNextLink), Collections.emptyList(), options);
    }

    @Property(name="qualities")
    @JsonIgnore
    public CollectionPage<PrintQuality> getQualities() {
        return new CollectionPage<PrintQuality>(contextPath, PrintQuality.class, this.qualities, Optional.ofNullable(qualitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="qualities")
    @JsonIgnore
    public CollectionPage<PrintQuality> getQualities(HttpRequestOptions options) {
        return new CollectionPage<PrintQuality>(contextPath, PrintQuality.class, this.qualities, Optional.ofNullable(qualitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="rightMargins")
    @JsonIgnore
    public CollectionPage<Integer> getRightMargins() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.rightMargins, Optional.ofNullable(rightMarginsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="rightMargins")
    @JsonIgnore
    public CollectionPage<Integer> getRightMargins(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.rightMargins, Optional.ofNullable(rightMarginsNextLink), Collections.emptyList(), options);
    }

    @Property(name="scalings")
    @JsonIgnore
    public CollectionPage<PrintScaling> getScalings() {
        return new CollectionPage<PrintScaling>(contextPath, PrintScaling.class, this.scalings, Optional.ofNullable(scalingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="scalings")
    @JsonIgnore
    public CollectionPage<PrintScaling> getScalings(HttpRequestOptions options) {
        return new CollectionPage<PrintScaling>(contextPath, PrintScaling.class, this.scalings, Optional.ofNullable(scalingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedColorConfigurations")
    @JsonIgnore
    public CollectionPage<PrintColorConfiguration> getSupportedColorConfigurations() {
        return new CollectionPage<PrintColorConfiguration>(contextPath, PrintColorConfiguration.class, this.supportedColorConfigurations, Optional.ofNullable(supportedColorConfigurationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedColorConfigurations")
    @JsonIgnore
    public CollectionPage<PrintColorConfiguration> getSupportedColorConfigurations(HttpRequestOptions options) {
        return new CollectionPage<PrintColorConfiguration>(contextPath, PrintColorConfiguration.class, this.supportedColorConfigurations, Optional.ofNullable(supportedColorConfigurationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedCopiesPerJob")
    @JsonIgnore
    public Optional<IntegerRange> getSupportedCopiesPerJob() {
        return Optional.ofNullable(supportedCopiesPerJob);
    }

    public PrinterCapabilities withSupportedCopiesPerJob(IntegerRange supportedCopiesPerJob) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.supportedCopiesPerJob = supportedCopiesPerJob;
        return _x;
    }

    @Property(name="supportedDocumentMimeTypes")
    @JsonIgnore
    public CollectionPage<String> getSupportedDocumentMimeTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedDocumentMimeTypes, Optional.ofNullable(supportedDocumentMimeTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedDocumentMimeTypes")
    @JsonIgnore
    public CollectionPage<String> getSupportedDocumentMimeTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedDocumentMimeTypes, Optional.ofNullable(supportedDocumentMimeTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedDuplexConfigurations")
    @JsonIgnore
    public CollectionPage<PrintDuplexConfiguration> getSupportedDuplexConfigurations() {
        return new CollectionPage<PrintDuplexConfiguration>(contextPath, PrintDuplexConfiguration.class, this.supportedDuplexConfigurations, Optional.ofNullable(supportedDuplexConfigurationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedDuplexConfigurations")
    @JsonIgnore
    public CollectionPage<PrintDuplexConfiguration> getSupportedDuplexConfigurations(HttpRequestOptions options) {
        return new CollectionPage<PrintDuplexConfiguration>(contextPath, PrintDuplexConfiguration.class, this.supportedDuplexConfigurations, Optional.ofNullable(supportedDuplexConfigurationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedFinishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getSupportedFinishings() {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.supportedFinishings, Optional.ofNullable(supportedFinishingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedFinishings")
    @JsonIgnore
    public CollectionPage<PrintFinishing> getSupportedFinishings(HttpRequestOptions options) {
        return new CollectionPage<PrintFinishing>(contextPath, PrintFinishing.class, this.supportedFinishings, Optional.ofNullable(supportedFinishingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedMediaColors")
    @JsonIgnore
    public CollectionPage<String> getSupportedMediaColors() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedMediaColors, Optional.ofNullable(supportedMediaColorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedMediaColors")
    @JsonIgnore
    public CollectionPage<String> getSupportedMediaColors(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedMediaColors, Optional.ofNullable(supportedMediaColorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedMediaSizes")
    @JsonIgnore
    public CollectionPage<String> getSupportedMediaSizes() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedMediaSizes, Optional.ofNullable(supportedMediaSizesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedMediaSizes")
    @JsonIgnore
    public CollectionPage<String> getSupportedMediaSizes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedMediaSizes, Optional.ofNullable(supportedMediaSizesNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedMediaTypes")
    @JsonIgnore
    public CollectionPage<PrintMediaType> getSupportedMediaTypes() {
        return new CollectionPage<PrintMediaType>(contextPath, PrintMediaType.class, this.supportedMediaTypes, Optional.ofNullable(supportedMediaTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedMediaTypes")
    @JsonIgnore
    public CollectionPage<PrintMediaType> getSupportedMediaTypes(HttpRequestOptions options) {
        return new CollectionPage<PrintMediaType>(contextPath, PrintMediaType.class, this.supportedMediaTypes, Optional.ofNullable(supportedMediaTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedOrientations")
    @JsonIgnore
    public CollectionPage<PrintOrientation> getSupportedOrientations() {
        return new CollectionPage<PrintOrientation>(contextPath, PrintOrientation.class, this.supportedOrientations, Optional.ofNullable(supportedOrientationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedOrientations")
    @JsonIgnore
    public CollectionPage<PrintOrientation> getSupportedOrientations(HttpRequestOptions options) {
        return new CollectionPage<PrintOrientation>(contextPath, PrintOrientation.class, this.supportedOrientations, Optional.ofNullable(supportedOrientationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedOutputBins")
    @JsonIgnore
    public CollectionPage<String> getSupportedOutputBins() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedOutputBins, Optional.ofNullable(supportedOutputBinsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedOutputBins")
    @JsonIgnore
    public CollectionPage<String> getSupportedOutputBins(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedOutputBins, Optional.ofNullable(supportedOutputBinsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedPagesPerSheet")
    @JsonIgnore
    public Optional<IntegerRange> getSupportedPagesPerSheet() {
        return Optional.ofNullable(supportedPagesPerSheet);
    }

    public PrinterCapabilities withSupportedPagesPerSheet(IntegerRange supportedPagesPerSheet) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.supportedPagesPerSheet = supportedPagesPerSheet;
        return _x;
    }

    @Property(name="supportedPresentationDirections")
    @JsonIgnore
    public CollectionPage<PrintPresentationDirection> getSupportedPresentationDirections() {
        return new CollectionPage<PrintPresentationDirection>(contextPath, PrintPresentationDirection.class, this.supportedPresentationDirections, Optional.ofNullable(supportedPresentationDirectionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedPresentationDirections")
    @JsonIgnore
    public CollectionPage<PrintPresentationDirection> getSupportedPresentationDirections(HttpRequestOptions options) {
        return new CollectionPage<PrintPresentationDirection>(contextPath, PrintPresentationDirection.class, this.supportedPresentationDirections, Optional.ofNullable(supportedPresentationDirectionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedPrintQualities")
    @JsonIgnore
    public CollectionPage<PrintQuality> getSupportedPrintQualities() {
        return new CollectionPage<PrintQuality>(contextPath, PrintQuality.class, this.supportedPrintQualities, Optional.ofNullable(supportedPrintQualitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedPrintQualities")
    @JsonIgnore
    public CollectionPage<PrintQuality> getSupportedPrintQualities(HttpRequestOptions options) {
        return new CollectionPage<PrintQuality>(contextPath, PrintQuality.class, this.supportedPrintQualities, Optional.ofNullable(supportedPrintQualitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportsFitPdfToPage")
    @JsonIgnore
    public Optional<Boolean> getSupportsFitPdfToPage() {
        return Optional.ofNullable(supportsFitPdfToPage);
    }

    public PrinterCapabilities withSupportsFitPdfToPage(Boolean supportsFitPdfToPage) {
        PrinterCapabilities _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printerCapabilities");
        _x.supportsFitPdfToPage = supportsFitPdfToPage;
        return _x;
    }

    @Property(name="topMargins")
    @JsonIgnore
    public CollectionPage<Integer> getTopMargins() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.topMargins, Optional.ofNullable(topMarginsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="topMargins")
    @JsonIgnore
    public CollectionPage<Integer> getTopMargins(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.topMargins, Optional.ofNullable(topMarginsNextLink), Collections.emptyList(), options);
    }

    public PrinterCapabilities withUnmappedField(String name, Object value) {
        PrinterCapabilities _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> bottomMargins;
        private String bottomMarginsNextLink;
        private Boolean collation;
        private List<PrintColorMode> colorModes;
        private String colorModesNextLink;
        private List<String> contentTypes;
        private String contentTypesNextLink;
        private IntegerRange copiesPerJob;
        private List<Integer> dpis;
        private String dpisNextLink;
        private List<PrintDuplexMode> duplexModes;
        private String duplexModesNextLink;
        private List<PrinterFeedDirection> feedDirections;
        private String feedDirectionsNextLink;
        private List<PrinterFeedOrientation> feedOrientations;
        private String feedOrientationsNextLink;
        private List<PrintFinishing> finishings;
        private String finishingsNextLink;
        private List<String> inputBins;
        private String inputBinsNextLink;
        private Boolean isColorPrintingSupported;
        private Boolean isPageRangeSupported;
        private List<Integer> leftMargins;
        private String leftMarginsNextLink;
        private List<String> mediaColors;
        private String mediaColorsNextLink;
        private List<String> mediaSizes;
        private String mediaSizesNextLink;
        private List<String> mediaTypes;
        private String mediaTypesNextLink;
        private List<PrintMultipageLayout> multipageLayouts;
        private String multipageLayoutsNextLink;
        private List<PrintOrientation> orientations;
        private String orientationsNextLink;
        private List<String> outputBins;
        private String outputBinsNextLink;
        private List<Integer> pagesPerSheet;
        private String pagesPerSheetNextLink;
        private List<PrintQuality> qualities;
        private String qualitiesNextLink;
        private List<Integer> rightMargins;
        private String rightMarginsNextLink;
        private List<PrintScaling> scalings;
        private String scalingsNextLink;
        private List<PrintColorConfiguration> supportedColorConfigurations;
        private String supportedColorConfigurationsNextLink;
        private IntegerRange supportedCopiesPerJob;
        private List<String> supportedDocumentMimeTypes;
        private String supportedDocumentMimeTypesNextLink;
        private List<PrintDuplexConfiguration> supportedDuplexConfigurations;
        private String supportedDuplexConfigurationsNextLink;
        private List<PrintFinishing> supportedFinishings;
        private String supportedFinishingsNextLink;
        private List<String> supportedMediaColors;
        private String supportedMediaColorsNextLink;
        private List<String> supportedMediaSizes;
        private String supportedMediaSizesNextLink;
        private List<PrintMediaType> supportedMediaTypes;
        private String supportedMediaTypesNextLink;
        private List<PrintOrientation> supportedOrientations;
        private String supportedOrientationsNextLink;
        private List<String> supportedOutputBins;
        private String supportedOutputBinsNextLink;
        private IntegerRange supportedPagesPerSheet;
        private List<PrintPresentationDirection> supportedPresentationDirections;
        private String supportedPresentationDirectionsNextLink;
        private List<PrintQuality> supportedPrintQualities;
        private String supportedPrintQualitiesNextLink;
        private Boolean supportsFitPdfToPage;
        private List<Integer> topMargins;
        private String topMarginsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder bottomMargins(List<Integer> bottomMargins) {
            this.bottomMargins = bottomMargins;
            this.changedFields = changedFields.add("bottomMargins");
            return this;
        }

        public Builder bottomMargins(Integer... bottomMargins) {
            return bottomMargins(Arrays.asList(bottomMargins));
        }

        public Builder bottomMarginsNextLink(String bottomMarginsNextLink) {
            this.bottomMarginsNextLink = bottomMarginsNextLink;
            this.changedFields = changedFields.add("bottomMargins");
            return this;
        }

        public Builder collation(Boolean collation) {
            this.collation = collation;
            this.changedFields = changedFields.add("collation");
            return this;
        }

        public Builder colorModes(List<PrintColorMode> colorModes) {
            this.colorModes = colorModes;
            this.changedFields = changedFields.add("colorModes");
            return this;
        }

        public Builder colorModes(PrintColorMode... colorModes) {
            return colorModes(Arrays.asList(colorModes));
        }

        public Builder colorModesNextLink(String colorModesNextLink) {
            this.colorModesNextLink = colorModesNextLink;
            this.changedFields = changedFields.add("colorModes");
            return this;
        }

        public Builder contentTypes(List<String> contentTypes) {
            this.contentTypes = contentTypes;
            this.changedFields = changedFields.add("contentTypes");
            return this;
        }

        public Builder contentTypes(String... contentTypes) {
            return contentTypes(Arrays.asList(contentTypes));
        }

        public Builder contentTypesNextLink(String contentTypesNextLink) {
            this.contentTypesNextLink = contentTypesNextLink;
            this.changedFields = changedFields.add("contentTypes");
            return this;
        }

        public Builder copiesPerJob(IntegerRange copiesPerJob) {
            this.copiesPerJob = copiesPerJob;
            this.changedFields = changedFields.add("copiesPerJob");
            return this;
        }

        public Builder dpis(List<Integer> dpis) {
            this.dpis = dpis;
            this.changedFields = changedFields.add("dpis");
            return this;
        }

        public Builder dpis(Integer... dpis) {
            return dpis(Arrays.asList(dpis));
        }

        public Builder dpisNextLink(String dpisNextLink) {
            this.dpisNextLink = dpisNextLink;
            this.changedFields = changedFields.add("dpis");
            return this;
        }

        public Builder duplexModes(List<PrintDuplexMode> duplexModes) {
            this.duplexModes = duplexModes;
            this.changedFields = changedFields.add("duplexModes");
            return this;
        }

        public Builder duplexModes(PrintDuplexMode... duplexModes) {
            return duplexModes(Arrays.asList(duplexModes));
        }

        public Builder duplexModesNextLink(String duplexModesNextLink) {
            this.duplexModesNextLink = duplexModesNextLink;
            this.changedFields = changedFields.add("duplexModes");
            return this;
        }

        public Builder feedDirections(List<PrinterFeedDirection> feedDirections) {
            this.feedDirections = feedDirections;
            this.changedFields = changedFields.add("feedDirections");
            return this;
        }

        public Builder feedDirections(PrinterFeedDirection... feedDirections) {
            return feedDirections(Arrays.asList(feedDirections));
        }

        public Builder feedDirectionsNextLink(String feedDirectionsNextLink) {
            this.feedDirectionsNextLink = feedDirectionsNextLink;
            this.changedFields = changedFields.add("feedDirections");
            return this;
        }

        public Builder feedOrientations(List<PrinterFeedOrientation> feedOrientations) {
            this.feedOrientations = feedOrientations;
            this.changedFields = changedFields.add("feedOrientations");
            return this;
        }

        public Builder feedOrientations(PrinterFeedOrientation... feedOrientations) {
            return feedOrientations(Arrays.asList(feedOrientations));
        }

        public Builder feedOrientationsNextLink(String feedOrientationsNextLink) {
            this.feedOrientationsNextLink = feedOrientationsNextLink;
            this.changedFields = changedFields.add("feedOrientations");
            return this;
        }

        public Builder finishings(List<PrintFinishing> finishings) {
            this.finishings = finishings;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder finishings(PrintFinishing... finishings) {
            return finishings(Arrays.asList(finishings));
        }

        public Builder finishingsNextLink(String finishingsNextLink) {
            this.finishingsNextLink = finishingsNextLink;
            this.changedFields = changedFields.add("finishings");
            return this;
        }

        public Builder inputBins(List<String> inputBins) {
            this.inputBins = inputBins;
            this.changedFields = changedFields.add("inputBins");
            return this;
        }

        public Builder inputBins(String... inputBins) {
            return inputBins(Arrays.asList(inputBins));
        }

        public Builder inputBinsNextLink(String inputBinsNextLink) {
            this.inputBinsNextLink = inputBinsNextLink;
            this.changedFields = changedFields.add("inputBins");
            return this;
        }

        public Builder isColorPrintingSupported(Boolean isColorPrintingSupported) {
            this.isColorPrintingSupported = isColorPrintingSupported;
            this.changedFields = changedFields.add("isColorPrintingSupported");
            return this;
        }

        public Builder isPageRangeSupported(Boolean isPageRangeSupported) {
            this.isPageRangeSupported = isPageRangeSupported;
            this.changedFields = changedFields.add("isPageRangeSupported");
            return this;
        }

        public Builder leftMargins(List<Integer> leftMargins) {
            this.leftMargins = leftMargins;
            this.changedFields = changedFields.add("leftMargins");
            return this;
        }

        public Builder leftMargins(Integer... leftMargins) {
            return leftMargins(Arrays.asList(leftMargins));
        }

        public Builder leftMarginsNextLink(String leftMarginsNextLink) {
            this.leftMarginsNextLink = leftMarginsNextLink;
            this.changedFields = changedFields.add("leftMargins");
            return this;
        }

        public Builder mediaColors(List<String> mediaColors) {
            this.mediaColors = mediaColors;
            this.changedFields = changedFields.add("mediaColors");
            return this;
        }

        public Builder mediaColors(String... mediaColors) {
            return mediaColors(Arrays.asList(mediaColors));
        }

        public Builder mediaColorsNextLink(String mediaColorsNextLink) {
            this.mediaColorsNextLink = mediaColorsNextLink;
            this.changedFields = changedFields.add("mediaColors");
            return this;
        }

        public Builder mediaSizes(List<String> mediaSizes) {
            this.mediaSizes = mediaSizes;
            this.changedFields = changedFields.add("mediaSizes");
            return this;
        }

        public Builder mediaSizes(String... mediaSizes) {
            return mediaSizes(Arrays.asList(mediaSizes));
        }

        public Builder mediaSizesNextLink(String mediaSizesNextLink) {
            this.mediaSizesNextLink = mediaSizesNextLink;
            this.changedFields = changedFields.add("mediaSizes");
            return this;
        }

        public Builder mediaTypes(List<String> mediaTypes) {
            this.mediaTypes = mediaTypes;
            this.changedFields = changedFields.add("mediaTypes");
            return this;
        }

        public Builder mediaTypes(String... mediaTypes) {
            return mediaTypes(Arrays.asList(mediaTypes));
        }

        public Builder mediaTypesNextLink(String mediaTypesNextLink) {
            this.mediaTypesNextLink = mediaTypesNextLink;
            this.changedFields = changedFields.add("mediaTypes");
            return this;
        }

        public Builder multipageLayouts(List<PrintMultipageLayout> multipageLayouts) {
            this.multipageLayouts = multipageLayouts;
            this.changedFields = changedFields.add("multipageLayouts");
            return this;
        }

        public Builder multipageLayouts(PrintMultipageLayout... multipageLayouts) {
            return multipageLayouts(Arrays.asList(multipageLayouts));
        }

        public Builder multipageLayoutsNextLink(String multipageLayoutsNextLink) {
            this.multipageLayoutsNextLink = multipageLayoutsNextLink;
            this.changedFields = changedFields.add("multipageLayouts");
            return this;
        }

        public Builder orientations(List<PrintOrientation> orientations) {
            this.orientations = orientations;
            this.changedFields = changedFields.add("orientations");
            return this;
        }

        public Builder orientations(PrintOrientation... orientations) {
            return orientations(Arrays.asList(orientations));
        }

        public Builder orientationsNextLink(String orientationsNextLink) {
            this.orientationsNextLink = orientationsNextLink;
            this.changedFields = changedFields.add("orientations");
            return this;
        }

        public Builder outputBins(List<String> outputBins) {
            this.outputBins = outputBins;
            this.changedFields = changedFields.add("outputBins");
            return this;
        }

        public Builder outputBins(String... outputBins) {
            return outputBins(Arrays.asList(outputBins));
        }

        public Builder outputBinsNextLink(String outputBinsNextLink) {
            this.outputBinsNextLink = outputBinsNextLink;
            this.changedFields = changedFields.add("outputBins");
            return this;
        }

        public Builder pagesPerSheet(List<Integer> pagesPerSheet) {
            this.pagesPerSheet = pagesPerSheet;
            this.changedFields = changedFields.add("pagesPerSheet");
            return this;
        }

        public Builder pagesPerSheet(Integer... pagesPerSheet) {
            return pagesPerSheet(Arrays.asList(pagesPerSheet));
        }

        public Builder pagesPerSheetNextLink(String pagesPerSheetNextLink) {
            this.pagesPerSheetNextLink = pagesPerSheetNextLink;
            this.changedFields = changedFields.add("pagesPerSheet");
            return this;
        }

        public Builder qualities(List<PrintQuality> qualities) {
            this.qualities = qualities;
            this.changedFields = changedFields.add("qualities");
            return this;
        }

        public Builder qualities(PrintQuality... qualities) {
            return qualities(Arrays.asList(qualities));
        }

        public Builder qualitiesNextLink(String qualitiesNextLink) {
            this.qualitiesNextLink = qualitiesNextLink;
            this.changedFields = changedFields.add("qualities");
            return this;
        }

        public Builder rightMargins(List<Integer> rightMargins) {
            this.rightMargins = rightMargins;
            this.changedFields = changedFields.add("rightMargins");
            return this;
        }

        public Builder rightMargins(Integer... rightMargins) {
            return rightMargins(Arrays.asList(rightMargins));
        }

        public Builder rightMarginsNextLink(String rightMarginsNextLink) {
            this.rightMarginsNextLink = rightMarginsNextLink;
            this.changedFields = changedFields.add("rightMargins");
            return this;
        }

        public Builder scalings(List<PrintScaling> scalings) {
            this.scalings = scalings;
            this.changedFields = changedFields.add("scalings");
            return this;
        }

        public Builder scalings(PrintScaling... scalings) {
            return scalings(Arrays.asList(scalings));
        }

        public Builder scalingsNextLink(String scalingsNextLink) {
            this.scalingsNextLink = scalingsNextLink;
            this.changedFields = changedFields.add("scalings");
            return this;
        }

        public Builder supportedColorConfigurations(List<PrintColorConfiguration> supportedColorConfigurations) {
            this.supportedColorConfigurations = supportedColorConfigurations;
            this.changedFields = changedFields.add("supportedColorConfigurations");
            return this;
        }

        public Builder supportedColorConfigurations(PrintColorConfiguration... supportedColorConfigurations) {
            return supportedColorConfigurations(Arrays.asList(supportedColorConfigurations));
        }

        public Builder supportedColorConfigurationsNextLink(String supportedColorConfigurationsNextLink) {
            this.supportedColorConfigurationsNextLink = supportedColorConfigurationsNextLink;
            this.changedFields = changedFields.add("supportedColorConfigurations");
            return this;
        }

        public Builder supportedCopiesPerJob(IntegerRange supportedCopiesPerJob) {
            this.supportedCopiesPerJob = supportedCopiesPerJob;
            this.changedFields = changedFields.add("supportedCopiesPerJob");
            return this;
        }

        public Builder supportedDocumentMimeTypes(List<String> supportedDocumentMimeTypes) {
            this.supportedDocumentMimeTypes = supportedDocumentMimeTypes;
            this.changedFields = changedFields.add("supportedDocumentMimeTypes");
            return this;
        }

        public Builder supportedDocumentMimeTypes(String... supportedDocumentMimeTypes) {
            return supportedDocumentMimeTypes(Arrays.asList(supportedDocumentMimeTypes));
        }

        public Builder supportedDocumentMimeTypesNextLink(String supportedDocumentMimeTypesNextLink) {
            this.supportedDocumentMimeTypesNextLink = supportedDocumentMimeTypesNextLink;
            this.changedFields = changedFields.add("supportedDocumentMimeTypes");
            return this;
        }

        public Builder supportedDuplexConfigurations(List<PrintDuplexConfiguration> supportedDuplexConfigurations) {
            this.supportedDuplexConfigurations = supportedDuplexConfigurations;
            this.changedFields = changedFields.add("supportedDuplexConfigurations");
            return this;
        }

        public Builder supportedDuplexConfigurations(PrintDuplexConfiguration... supportedDuplexConfigurations) {
            return supportedDuplexConfigurations(Arrays.asList(supportedDuplexConfigurations));
        }

        public Builder supportedDuplexConfigurationsNextLink(String supportedDuplexConfigurationsNextLink) {
            this.supportedDuplexConfigurationsNextLink = supportedDuplexConfigurationsNextLink;
            this.changedFields = changedFields.add("supportedDuplexConfigurations");
            return this;
        }

        public Builder supportedFinishings(List<PrintFinishing> supportedFinishings) {
            this.supportedFinishings = supportedFinishings;
            this.changedFields = changedFields.add("supportedFinishings");
            return this;
        }

        public Builder supportedFinishings(PrintFinishing... supportedFinishings) {
            return supportedFinishings(Arrays.asList(supportedFinishings));
        }

        public Builder supportedFinishingsNextLink(String supportedFinishingsNextLink) {
            this.supportedFinishingsNextLink = supportedFinishingsNextLink;
            this.changedFields = changedFields.add("supportedFinishings");
            return this;
        }

        public Builder supportedMediaColors(List<String> supportedMediaColors) {
            this.supportedMediaColors = supportedMediaColors;
            this.changedFields = changedFields.add("supportedMediaColors");
            return this;
        }

        public Builder supportedMediaColors(String... supportedMediaColors) {
            return supportedMediaColors(Arrays.asList(supportedMediaColors));
        }

        public Builder supportedMediaColorsNextLink(String supportedMediaColorsNextLink) {
            this.supportedMediaColorsNextLink = supportedMediaColorsNextLink;
            this.changedFields = changedFields.add("supportedMediaColors");
            return this;
        }

        public Builder supportedMediaSizes(List<String> supportedMediaSizes) {
            this.supportedMediaSizes = supportedMediaSizes;
            this.changedFields = changedFields.add("supportedMediaSizes");
            return this;
        }

        public Builder supportedMediaSizes(String... supportedMediaSizes) {
            return supportedMediaSizes(Arrays.asList(supportedMediaSizes));
        }

        public Builder supportedMediaSizesNextLink(String supportedMediaSizesNextLink) {
            this.supportedMediaSizesNextLink = supportedMediaSizesNextLink;
            this.changedFields = changedFields.add("supportedMediaSizes");
            return this;
        }

        public Builder supportedMediaTypes(List<PrintMediaType> supportedMediaTypes) {
            this.supportedMediaTypes = supportedMediaTypes;
            this.changedFields = changedFields.add("supportedMediaTypes");
            return this;
        }

        public Builder supportedMediaTypes(PrintMediaType... supportedMediaTypes) {
            return supportedMediaTypes(Arrays.asList(supportedMediaTypes));
        }

        public Builder supportedMediaTypesNextLink(String supportedMediaTypesNextLink) {
            this.supportedMediaTypesNextLink = supportedMediaTypesNextLink;
            this.changedFields = changedFields.add("supportedMediaTypes");
            return this;
        }

        public Builder supportedOrientations(List<PrintOrientation> supportedOrientations) {
            this.supportedOrientations = supportedOrientations;
            this.changedFields = changedFields.add("supportedOrientations");
            return this;
        }

        public Builder supportedOrientations(PrintOrientation... supportedOrientations) {
            return supportedOrientations(Arrays.asList(supportedOrientations));
        }

        public Builder supportedOrientationsNextLink(String supportedOrientationsNextLink) {
            this.supportedOrientationsNextLink = supportedOrientationsNextLink;
            this.changedFields = changedFields.add("supportedOrientations");
            return this;
        }

        public Builder supportedOutputBins(List<String> supportedOutputBins) {
            this.supportedOutputBins = supportedOutputBins;
            this.changedFields = changedFields.add("supportedOutputBins");
            return this;
        }

        public Builder supportedOutputBins(String... supportedOutputBins) {
            return supportedOutputBins(Arrays.asList(supportedOutputBins));
        }

        public Builder supportedOutputBinsNextLink(String supportedOutputBinsNextLink) {
            this.supportedOutputBinsNextLink = supportedOutputBinsNextLink;
            this.changedFields = changedFields.add("supportedOutputBins");
            return this;
        }

        public Builder supportedPagesPerSheet(IntegerRange supportedPagesPerSheet) {
            this.supportedPagesPerSheet = supportedPagesPerSheet;
            this.changedFields = changedFields.add("supportedPagesPerSheet");
            return this;
        }

        public Builder supportedPresentationDirections(List<PrintPresentationDirection> supportedPresentationDirections) {
            this.supportedPresentationDirections = supportedPresentationDirections;
            this.changedFields = changedFields.add("supportedPresentationDirections");
            return this;
        }

        public Builder supportedPresentationDirections(PrintPresentationDirection... supportedPresentationDirections) {
            return supportedPresentationDirections(Arrays.asList(supportedPresentationDirections));
        }

        public Builder supportedPresentationDirectionsNextLink(String supportedPresentationDirectionsNextLink) {
            this.supportedPresentationDirectionsNextLink = supportedPresentationDirectionsNextLink;
            this.changedFields = changedFields.add("supportedPresentationDirections");
            return this;
        }

        public Builder supportedPrintQualities(List<PrintQuality> supportedPrintQualities) {
            this.supportedPrintQualities = supportedPrintQualities;
            this.changedFields = changedFields.add("supportedPrintQualities");
            return this;
        }

        public Builder supportedPrintQualities(PrintQuality... supportedPrintQualities) {
            return supportedPrintQualities(Arrays.asList(supportedPrintQualities));
        }

        public Builder supportedPrintQualitiesNextLink(String supportedPrintQualitiesNextLink) {
            this.supportedPrintQualitiesNextLink = supportedPrintQualitiesNextLink;
            this.changedFields = changedFields.add("supportedPrintQualities");
            return this;
        }

        public Builder supportsFitPdfToPage(Boolean supportsFitPdfToPage) {
            this.supportsFitPdfToPage = supportsFitPdfToPage;
            this.changedFields = changedFields.add("supportsFitPdfToPage");
            return this;
        }

        public Builder topMargins(List<Integer> topMargins) {
            this.topMargins = topMargins;
            this.changedFields = changedFields.add("topMargins");
            return this;
        }

        public Builder topMargins(Integer... topMargins) {
            return topMargins(Arrays.asList(topMargins));
        }

        public Builder topMarginsNextLink(String topMarginsNextLink) {
            this.topMarginsNextLink = topMarginsNextLink;
            this.changedFields = changedFields.add("topMargins");
            return this;
        }

        public PrinterCapabilities build() {
            PrinterCapabilities _x = new PrinterCapabilities();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printerCapabilities";
            _x.bottomMargins = bottomMargins;
            _x.bottomMarginsNextLink = bottomMarginsNextLink;
            _x.collation = collation;
            _x.colorModes = colorModes;
            _x.colorModesNextLink = colorModesNextLink;
            _x.contentTypes = contentTypes;
            _x.contentTypesNextLink = contentTypesNextLink;
            _x.copiesPerJob = copiesPerJob;
            _x.dpis = dpis;
            _x.dpisNextLink = dpisNextLink;
            _x.duplexModes = duplexModes;
            _x.duplexModesNextLink = duplexModesNextLink;
            _x.feedDirections = feedDirections;
            _x.feedDirectionsNextLink = feedDirectionsNextLink;
            _x.feedOrientations = feedOrientations;
            _x.feedOrientationsNextLink = feedOrientationsNextLink;
            _x.finishings = finishings;
            _x.finishingsNextLink = finishingsNextLink;
            _x.inputBins = inputBins;
            _x.inputBinsNextLink = inputBinsNextLink;
            _x.isColorPrintingSupported = isColorPrintingSupported;
            _x.isPageRangeSupported = isPageRangeSupported;
            _x.leftMargins = leftMargins;
            _x.leftMarginsNextLink = leftMarginsNextLink;
            _x.mediaColors = mediaColors;
            _x.mediaColorsNextLink = mediaColorsNextLink;
            _x.mediaSizes = mediaSizes;
            _x.mediaSizesNextLink = mediaSizesNextLink;
            _x.mediaTypes = mediaTypes;
            _x.mediaTypesNextLink = mediaTypesNextLink;
            _x.multipageLayouts = multipageLayouts;
            _x.multipageLayoutsNextLink = multipageLayoutsNextLink;
            _x.orientations = orientations;
            _x.orientationsNextLink = orientationsNextLink;
            _x.outputBins = outputBins;
            _x.outputBinsNextLink = outputBinsNextLink;
            _x.pagesPerSheet = pagesPerSheet;
            _x.pagesPerSheetNextLink = pagesPerSheetNextLink;
            _x.qualities = qualities;
            _x.qualitiesNextLink = qualitiesNextLink;
            _x.rightMargins = rightMargins;
            _x.rightMarginsNextLink = rightMarginsNextLink;
            _x.scalings = scalings;
            _x.scalingsNextLink = scalingsNextLink;
            _x.supportedColorConfigurations = supportedColorConfigurations;
            _x.supportedColorConfigurationsNextLink = supportedColorConfigurationsNextLink;
            _x.supportedCopiesPerJob = supportedCopiesPerJob;
            _x.supportedDocumentMimeTypes = supportedDocumentMimeTypes;
            _x.supportedDocumentMimeTypesNextLink = supportedDocumentMimeTypesNextLink;
            _x.supportedDuplexConfigurations = supportedDuplexConfigurations;
            _x.supportedDuplexConfigurationsNextLink = supportedDuplexConfigurationsNextLink;
            _x.supportedFinishings = supportedFinishings;
            _x.supportedFinishingsNextLink = supportedFinishingsNextLink;
            _x.supportedMediaColors = supportedMediaColors;
            _x.supportedMediaColorsNextLink = supportedMediaColorsNextLink;
            _x.supportedMediaSizes = supportedMediaSizes;
            _x.supportedMediaSizesNextLink = supportedMediaSizesNextLink;
            _x.supportedMediaTypes = supportedMediaTypes;
            _x.supportedMediaTypesNextLink = supportedMediaTypesNextLink;
            _x.supportedOrientations = supportedOrientations;
            _x.supportedOrientationsNextLink = supportedOrientationsNextLink;
            _x.supportedOutputBins = supportedOutputBins;
            _x.supportedOutputBinsNextLink = supportedOutputBinsNextLink;
            _x.supportedPagesPerSheet = supportedPagesPerSheet;
            _x.supportedPresentationDirections = supportedPresentationDirections;
            _x.supportedPresentationDirectionsNextLink = supportedPresentationDirectionsNextLink;
            _x.supportedPrintQualities = supportedPrintQualities;
            _x.supportedPrintQualitiesNextLink = supportedPrintQualitiesNextLink;
            _x.supportsFitPdfToPage = supportsFitPdfToPage;
            _x.topMargins = topMargins;
            _x.topMarginsNextLink = topMarginsNextLink;
            return _x;
        }
    }

    private PrinterCapabilities _copy() {
        PrinterCapabilities _x = new PrinterCapabilities();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.bottomMargins = bottomMargins;
        _x.collation = collation;
        _x.colorModes = colorModes;
        _x.contentTypes = contentTypes;
        _x.copiesPerJob = copiesPerJob;
        _x.dpis = dpis;
        _x.duplexModes = duplexModes;
        _x.feedDirections = feedDirections;
        _x.feedOrientations = feedOrientations;
        _x.finishings = finishings;
        _x.inputBins = inputBins;
        _x.isColorPrintingSupported = isColorPrintingSupported;
        _x.isPageRangeSupported = isPageRangeSupported;
        _x.leftMargins = leftMargins;
        _x.mediaColors = mediaColors;
        _x.mediaSizes = mediaSizes;
        _x.mediaTypes = mediaTypes;
        _x.multipageLayouts = multipageLayouts;
        _x.orientations = orientations;
        _x.outputBins = outputBins;
        _x.pagesPerSheet = pagesPerSheet;
        _x.qualities = qualities;
        _x.rightMargins = rightMargins;
        _x.scalings = scalings;
        _x.supportedColorConfigurations = supportedColorConfigurations;
        _x.supportedCopiesPerJob = supportedCopiesPerJob;
        _x.supportedDocumentMimeTypes = supportedDocumentMimeTypes;
        _x.supportedDuplexConfigurations = supportedDuplexConfigurations;
        _x.supportedFinishings = supportedFinishings;
        _x.supportedMediaColors = supportedMediaColors;
        _x.supportedMediaSizes = supportedMediaSizes;
        _x.supportedMediaTypes = supportedMediaTypes;
        _x.supportedOrientations = supportedOrientations;
        _x.supportedOutputBins = supportedOutputBins;
        _x.supportedPagesPerSheet = supportedPagesPerSheet;
        _x.supportedPresentationDirections = supportedPresentationDirections;
        _x.supportedPrintQualities = supportedPrintQualities;
        _x.supportsFitPdfToPage = supportsFitPdfToPage;
        _x.topMargins = topMargins;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrinterCapabilities[");
        b.append("bottomMargins=");
        b.append(this.bottomMargins);
        b.append(", ");
        b.append("collation=");
        b.append(this.collation);
        b.append(", ");
        b.append("colorModes=");
        b.append(this.colorModes);
        b.append(", ");
        b.append("contentTypes=");
        b.append(this.contentTypes);
        b.append(", ");
        b.append("copiesPerJob=");
        b.append(this.copiesPerJob);
        b.append(", ");
        b.append("dpis=");
        b.append(this.dpis);
        b.append(", ");
        b.append("duplexModes=");
        b.append(this.duplexModes);
        b.append(", ");
        b.append("feedDirections=");
        b.append(this.feedDirections);
        b.append(", ");
        b.append("feedOrientations=");
        b.append(this.feedOrientations);
        b.append(", ");
        b.append("finishings=");
        b.append(this.finishings);
        b.append(", ");
        b.append("inputBins=");
        b.append(this.inputBins);
        b.append(", ");
        b.append("isColorPrintingSupported=");
        b.append(this.isColorPrintingSupported);
        b.append(", ");
        b.append("isPageRangeSupported=");
        b.append(this.isPageRangeSupported);
        b.append(", ");
        b.append("leftMargins=");
        b.append(this.leftMargins);
        b.append(", ");
        b.append("mediaColors=");
        b.append(this.mediaColors);
        b.append(", ");
        b.append("mediaSizes=");
        b.append(this.mediaSizes);
        b.append(", ");
        b.append("mediaTypes=");
        b.append(this.mediaTypes);
        b.append(", ");
        b.append("multipageLayouts=");
        b.append(this.multipageLayouts);
        b.append(", ");
        b.append("orientations=");
        b.append(this.orientations);
        b.append(", ");
        b.append("outputBins=");
        b.append(this.outputBins);
        b.append(", ");
        b.append("pagesPerSheet=");
        b.append(this.pagesPerSheet);
        b.append(", ");
        b.append("qualities=");
        b.append(this.qualities);
        b.append(", ");
        b.append("rightMargins=");
        b.append(this.rightMargins);
        b.append(", ");
        b.append("scalings=");
        b.append(this.scalings);
        b.append(", ");
        b.append("supportedColorConfigurations=");
        b.append(this.supportedColorConfigurations);
        b.append(", ");
        b.append("supportedCopiesPerJob=");
        b.append(this.supportedCopiesPerJob);
        b.append(", ");
        b.append("supportedDocumentMimeTypes=");
        b.append(this.supportedDocumentMimeTypes);
        b.append(", ");
        b.append("supportedDuplexConfigurations=");
        b.append(this.supportedDuplexConfigurations);
        b.append(", ");
        b.append("supportedFinishings=");
        b.append(this.supportedFinishings);
        b.append(", ");
        b.append("supportedMediaColors=");
        b.append(this.supportedMediaColors);
        b.append(", ");
        b.append("supportedMediaSizes=");
        b.append(this.supportedMediaSizes);
        b.append(", ");
        b.append("supportedMediaTypes=");
        b.append(this.supportedMediaTypes);
        b.append(", ");
        b.append("supportedOrientations=");
        b.append(this.supportedOrientations);
        b.append(", ");
        b.append("supportedOutputBins=");
        b.append(this.supportedOutputBins);
        b.append(", ");
        b.append("supportedPagesPerSheet=");
        b.append(this.supportedPagesPerSheet);
        b.append(", ");
        b.append("supportedPresentationDirections=");
        b.append(this.supportedPresentationDirections);
        b.append(", ");
        b.append("supportedPrintQualities=");
        b.append(this.supportedPrintQualities);
        b.append(", ");
        b.append("supportsFitPdfToPage=");
        b.append(this.supportsFitPdfToPage);
        b.append(", ");
        b.append("topMargins=");
        b.append(this.topMargins);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
