package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PrintTaskProcessingState;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class PrintTaskStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("state")
    protected PrintTaskProcessingState state;

    protected PrintTaskStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printTaskStatus";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PrintTaskStatus withDescription(String description) {
        PrintTaskStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printTaskStatus");
        _x.description = description;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<PrintTaskProcessingState> getState() {
        return Optional.ofNullable(state);
    }

    public PrintTaskStatus withState(PrintTaskProcessingState state) {
        PrintTaskStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printTaskStatus");
        _x.state = state;
        return _x;
    }

    public PrintTaskStatus withUnmappedField(String name, Object value) {
        PrintTaskStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private PrintTaskProcessingState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder state(PrintTaskProcessingState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public PrintTaskStatus build() {
            PrintTaskStatus _x = new PrintTaskStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.printTaskStatus";
            _x.description = description;
            _x.state = state;
            return _x;
        }
    }

    private PrintTaskStatus _copy() {
        PrintTaskStatus _x = new PrintTaskStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintTaskStatus[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
