package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "principalScopes", 
    "resourceScopes"})
@JsonInclude(Include.NON_NULL)
public class PrincipalResourceMembershipsScope extends AccessReviewScope implements ODataType {

    @JsonProperty("principalScopes")
    protected List<AccessReviewScope> principalScopes;

    @JsonProperty("principalScopes@nextLink")
    protected String principalScopesNextLink;

    @JsonProperty("resourceScopes")
    protected List<AccessReviewScope> resourceScopes;

    @JsonProperty("resourceScopes@nextLink")
    protected String resourceScopesNextLink;

    protected PrincipalResourceMembershipsScope() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.principalResourceMembershipsScope";
    }

    @Property(name="principalScopes")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getPrincipalScopes() {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, this.principalScopes, Optional.ofNullable(principalScopesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="principalScopes")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getPrincipalScopes(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, this.principalScopes, Optional.ofNullable(principalScopesNextLink), Collections.emptyList(), options);
    }

    @Property(name="resourceScopes")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getResourceScopes() {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, this.resourceScopes, Optional.ofNullable(resourceScopesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="resourceScopes")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getResourceScopes(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, this.resourceScopes, Optional.ofNullable(resourceScopesNextLink), Collections.emptyList(), options);
    }

    public PrincipalResourceMembershipsScope withUnmappedField(String name, Object value) {
        PrincipalResourceMembershipsScope _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrincipalResourceMembershipsScope() {
        return new Builder();
    }

    public static final class Builder {
        private List<AccessReviewScope> principalScopes;
        private String principalScopesNextLink;
        private List<AccessReviewScope> resourceScopes;
        private String resourceScopesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder principalScopes(List<AccessReviewScope> principalScopes) {
            this.principalScopes = principalScopes;
            this.changedFields = changedFields.add("principalScopes");
            return this;
        }

        public Builder principalScopes(AccessReviewScope... principalScopes) {
            return principalScopes(Arrays.asList(principalScopes));
        }

        public Builder principalScopesNextLink(String principalScopesNextLink) {
            this.principalScopesNextLink = principalScopesNextLink;
            this.changedFields = changedFields.add("principalScopes");
            return this;
        }

        public Builder resourceScopes(List<AccessReviewScope> resourceScopes) {
            this.resourceScopes = resourceScopes;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public Builder resourceScopes(AccessReviewScope... resourceScopes) {
            return resourceScopes(Arrays.asList(resourceScopes));
        }

        public Builder resourceScopesNextLink(String resourceScopesNextLink) {
            this.resourceScopesNextLink = resourceScopesNextLink;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public PrincipalResourceMembershipsScope build() {
            PrincipalResourceMembershipsScope _x = new PrincipalResourceMembershipsScope();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.principalResourceMembershipsScope";
            _x.principalScopes = principalScopes;
            _x.principalScopesNextLink = principalScopesNextLink;
            _x.resourceScopes = resourceScopes;
            _x.resourceScopesNextLink = resourceScopesNextLink;
            return _x;
        }
    }

    private PrincipalResourceMembershipsScope _copy() {
        PrincipalResourceMembershipsScope _x = new PrincipalResourceMembershipsScope();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.principalScopes = principalScopes;
        _x.resourceScopes = resourceScopes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrincipalResourceMembershipsScope[");
        b.append("principalScopes=");
        b.append(this.principalScopes);
        b.append(", ");
        b.append("resourceScopes=");
        b.append(this.resourceScopes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
