package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "permissionIds"})
@JsonInclude(Include.NON_NULL)
public class PreAuthorizedApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("permissionIds")
    protected List<String> permissionIds;

    @JsonProperty("permissionIds@nextLink")
    protected String permissionIdsNextLink;

    protected PreAuthorizedApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.preAuthorizedApplication";
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public PreAuthorizedApplication withAppId(String appId) {
        PreAuthorizedApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.preAuthorizedApplication");
        _x.appId = appId;
        return _x;
    }

    @Property(name="permissionIds")
    @JsonIgnore
    public CollectionPage<String> getPermissionIds() {
        return new CollectionPage<String>(contextPath, String.class, this.permissionIds, Optional.ofNullable(permissionIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="permissionIds")
    @JsonIgnore
    public CollectionPage<String> getPermissionIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.permissionIds, Optional.ofNullable(permissionIdsNextLink), Collections.emptyList(), options);
    }

    public PreAuthorizedApplication withUnmappedField(String name, Object value) {
        PreAuthorizedApplication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private List<String> permissionIds;
        private String permissionIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder permissionIds(List<String> permissionIds) {
            this.permissionIds = permissionIds;
            this.changedFields = changedFields.add("permissionIds");
            return this;
        }

        public Builder permissionIds(String... permissionIds) {
            return permissionIds(Arrays.asList(permissionIds));
        }

        public Builder permissionIdsNextLink(String permissionIdsNextLink) {
            this.permissionIdsNextLink = permissionIdsNextLink;
            this.changedFields = changedFields.add("permissionIds");
            return this;
        }

        public PreAuthorizedApplication build() {
            PreAuthorizedApplication _x = new PreAuthorizedApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.preAuthorizedApplication";
            _x.appId = appId;
            _x.permissionIds = permissionIds;
            _x.permissionIdsNextLink = permissionIdsNextLink;
            return _x;
        }
    }

    private PreAuthorizedApplication _copy() {
        PreAuthorizedApplication _x = new PreAuthorizedApplication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        _x.permissionIds = permissionIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PreAuthorizedApplication[");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("permissionIds=");
        b.append(this.permissionIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
