package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "city", 
    "countryLetterCode", 
    "postalCode", 
    "state", 
    "street"})
@JsonInclude(Include.NON_NULL)
public class PostalAddressType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("countryLetterCode")
    protected String countryLetterCode;

    @JsonProperty("postalCode")
    protected String postalCode;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("street")
    protected String street;

    protected PostalAddressType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.postalAddressType";
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public PostalAddressType withCity(String city) {
        PostalAddressType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.postalAddressType");
        _x.city = city;
        return _x;
    }

    @Property(name="countryLetterCode")
    @JsonIgnore
    public Optional<String> getCountryLetterCode() {
        return Optional.ofNullable(countryLetterCode);
    }

    public PostalAddressType withCountryLetterCode(String countryLetterCode) {
        PostalAddressType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.postalAddressType");
        _x.countryLetterCode = countryLetterCode;
        return _x;
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public PostalAddressType withPostalCode(String postalCode) {
        PostalAddressType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.postalAddressType");
        _x.postalCode = postalCode;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public PostalAddressType withState(String state) {
        PostalAddressType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.postalAddressType");
        _x.state = state;
        return _x;
    }

    @Property(name="street")
    @JsonIgnore
    public Optional<String> getStreet() {
        return Optional.ofNullable(street);
    }

    public PostalAddressType withStreet(String street) {
        PostalAddressType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.postalAddressType");
        _x.street = street;
        return _x;
    }

    public PostalAddressType withUnmappedField(String name, Object value) {
        PostalAddressType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String city;
        private String countryLetterCode;
        private String postalCode;
        private String state;
        private String street;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder countryLetterCode(String countryLetterCode) {
            this.countryLetterCode = countryLetterCode;
            this.changedFields = changedFields.add("countryLetterCode");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            this.changedFields = changedFields.add("street");
            return this;
        }

        public PostalAddressType build() {
            PostalAddressType _x = new PostalAddressType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.postalAddressType";
            _x.city = city;
            _x.countryLetterCode = countryLetterCode;
            _x.postalCode = postalCode;
            _x.state = state;
            _x.street = street;
            return _x;
        }
    }

    private PostalAddressType _copy() {
        PostalAddressType _x = new PostalAddressType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.city = city;
        _x.countryLetterCode = countryLetterCode;
        _x.postalCode = postalCode;
        _x.state = state;
        _x.street = street;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PostalAddressType[");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("countryLetterCode=");
        b.append(this.countryLetterCode);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("street=");
        b.append(this.street);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
