package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "company", 
    "description", 
    "endMonthYear", 
    "jobTitle", 
    "role", 
    "startMonthYear", 
    "summary"})
@JsonInclude(Include.NON_NULL)
public class PositionDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("company")
    protected CompanyDetail company;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("endMonthYear")
    protected LocalDate endMonthYear;

    @JsonProperty("jobTitle")
    protected String jobTitle;

    @JsonProperty("role")
    protected String role;

    @JsonProperty("startMonthYear")
    protected LocalDate startMonthYear;

    @JsonProperty("summary")
    protected String summary;

    protected PositionDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.positionDetail";
    }

    @Property(name="company")
    @JsonIgnore
    public Optional<CompanyDetail> getCompany() {
        return Optional.ofNullable(company);
    }

    public PositionDetail withCompany(CompanyDetail company) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.company = company;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public PositionDetail withDescription(String description) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.description = description;
        return _x;
    }

    @Property(name="endMonthYear")
    @JsonIgnore
    public Optional<LocalDate> getEndMonthYear() {
        return Optional.ofNullable(endMonthYear);
    }

    public PositionDetail withEndMonthYear(LocalDate endMonthYear) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.endMonthYear = endMonthYear;
        return _x;
    }

    @Property(name="jobTitle")
    @JsonIgnore
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    public PositionDetail withJobTitle(String jobTitle) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.jobTitle = jobTitle;
        return _x;
    }

    @Property(name="role")
    @JsonIgnore
    public Optional<String> getRole() {
        return Optional.ofNullable(role);
    }

    public PositionDetail withRole(String role) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.role = role;
        return _x;
    }

    @Property(name="startMonthYear")
    @JsonIgnore
    public Optional<LocalDate> getStartMonthYear() {
        return Optional.ofNullable(startMonthYear);
    }

    public PositionDetail withStartMonthYear(LocalDate startMonthYear) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.startMonthYear = startMonthYear;
        return _x;
    }

    @Property(name="summary")
    @JsonIgnore
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    public PositionDetail withSummary(String summary) {
        PositionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.positionDetail");
        _x.summary = summary;
        return _x;
    }

    public PositionDetail withUnmappedField(String name, Object value) {
        PositionDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CompanyDetail company;
        private String description;
        private LocalDate endMonthYear;
        private String jobTitle;
        private String role;
        private LocalDate startMonthYear;
        private String summary;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder company(CompanyDetail company) {
            this.company = company;
            this.changedFields = changedFields.add("company");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder endMonthYear(LocalDate endMonthYear) {
            this.endMonthYear = endMonthYear;
            this.changedFields = changedFields.add("endMonthYear");
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.changedFields = changedFields.add("jobTitle");
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder startMonthYear(LocalDate startMonthYear) {
            this.startMonthYear = startMonthYear;
            this.changedFields = changedFields.add("startMonthYear");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.changedFields = changedFields.add("summary");
            return this;
        }

        public PositionDetail build() {
            PositionDetail _x = new PositionDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.positionDetail";
            _x.company = company;
            _x.description = description;
            _x.endMonthYear = endMonthYear;
            _x.jobTitle = jobTitle;
            _x.role = role;
            _x.startMonthYear = startMonthYear;
            _x.summary = summary;
            return _x;
        }
    }

    private PositionDetail _copy() {
        PositionDetail _x = new PositionDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.company = company;
        _x.description = description;
        _x.endMonthYear = endMonthYear;
        _x.jobTitle = jobTitle;
        _x.role = role;
        _x.startMonthYear = startMonthYear;
        _x.summary = summary;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PositionDetail[");
        b.append("company=");
        b.append(this.company);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("endMonthYear=");
        b.append(this.endMonthYear);
        b.append(", ");
        b.append("jobTitle=");
        b.append(this.jobTitle);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("startMonthYear=");
        b.append(this.startMonthYear);
        b.append(", ");
        b.append("summary=");
        b.append(this.summary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
