package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastModifiedDateTime", 
    "publicationId", 
    "publishedToPlanId", 
    "publishingTeamId", 
    "publishingTeamName"})
@JsonInclude(Include.NON_NULL)
public class PlannerTeamsPublicationInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("publicationId")
    protected String publicationId;

    @JsonProperty("publishedToPlanId")
    protected String publishedToPlanId;

    @JsonProperty("publishingTeamId")
    protected String publishingTeamId;

    @JsonProperty("publishingTeamName")
    protected String publishingTeamName;

    protected PlannerTeamsPublicationInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerTeamsPublicationInfo";
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public PlannerTeamsPublicationInfo withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        PlannerTeamsPublicationInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTeamsPublicationInfo");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="publicationId")
    @JsonIgnore
    public Optional<String> getPublicationId() {
        return Optional.ofNullable(publicationId);
    }

    public PlannerTeamsPublicationInfo withPublicationId(String publicationId) {
        PlannerTeamsPublicationInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTeamsPublicationInfo");
        _x.publicationId = publicationId;
        return _x;
    }

    @Property(name="publishedToPlanId")
    @JsonIgnore
    public Optional<String> getPublishedToPlanId() {
        return Optional.ofNullable(publishedToPlanId);
    }

    public PlannerTeamsPublicationInfo withPublishedToPlanId(String publishedToPlanId) {
        PlannerTeamsPublicationInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTeamsPublicationInfo");
        _x.publishedToPlanId = publishedToPlanId;
        return _x;
    }

    @Property(name="publishingTeamId")
    @JsonIgnore
    public Optional<String> getPublishingTeamId() {
        return Optional.ofNullable(publishingTeamId);
    }

    public PlannerTeamsPublicationInfo withPublishingTeamId(String publishingTeamId) {
        PlannerTeamsPublicationInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTeamsPublicationInfo");
        _x.publishingTeamId = publishingTeamId;
        return _x;
    }

    @Property(name="publishingTeamName")
    @JsonIgnore
    public Optional<String> getPublishingTeamName() {
        return Optional.ofNullable(publishingTeamName);
    }

    public PlannerTeamsPublicationInfo withPublishingTeamName(String publishingTeamName) {
        PlannerTeamsPublicationInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerTeamsPublicationInfo");
        _x.publishingTeamName = publishingTeamName;
        return _x;
    }

    public PlannerTeamsPublicationInfo withUnmappedField(String name, Object value) {
        PlannerTeamsPublicationInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastModifiedDateTime;
        private String publicationId;
        private String publishedToPlanId;
        private String publishingTeamId;
        private String publishingTeamName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder publicationId(String publicationId) {
            this.publicationId = publicationId;
            this.changedFields = changedFields.add("publicationId");
            return this;
        }

        public Builder publishedToPlanId(String publishedToPlanId) {
            this.publishedToPlanId = publishedToPlanId;
            this.changedFields = changedFields.add("publishedToPlanId");
            return this;
        }

        public Builder publishingTeamId(String publishingTeamId) {
            this.publishingTeamId = publishingTeamId;
            this.changedFields = changedFields.add("publishingTeamId");
            return this;
        }

        public Builder publishingTeamName(String publishingTeamName) {
            this.publishingTeamName = publishingTeamName;
            this.changedFields = changedFields.add("publishingTeamName");
            return this;
        }

        public PlannerTeamsPublicationInfo build() {
            PlannerTeamsPublicationInfo _x = new PlannerTeamsPublicationInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerTeamsPublicationInfo";
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.publicationId = publicationId;
            _x.publishedToPlanId = publishedToPlanId;
            _x.publishingTeamId = publishingTeamId;
            _x.publishingTeamName = publishingTeamName;
            return _x;
        }
    }

    private PlannerTeamsPublicationInfo _copy() {
        PlannerTeamsPublicationInfo _x = new PlannerTeamsPublicationInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.publicationId = publicationId;
        _x.publishedToPlanId = publishedToPlanId;
        _x.publishingTeamId = publishingTeamId;
        _x.publishingTeamName = publishingTeamName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerTeamsPublicationInfo[");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("publicationId=");
        b.append(this.publicationId);
        b.append(", ");
        b.append("publishedToPlanId=");
        b.append(this.publishedToPlanId);
        b.append(", ");
        b.append("publishingTeamId=");
        b.append(this.publishingTeamId);
        b.append(", ");
        b.append("publishingTeamName=");
        b.append(this.publishingTeamName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
