package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.PlannerContainerType;

@JsonPropertyOrder({
    "@odata.type", 
    "containerId", 
    "type", 
    "url"})
@JsonInclude(Include.NON_NULL)
public class PlannerPlanContainer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("containerId")
    protected String containerId;

    @JsonProperty("type")
    protected PlannerContainerType type;

    @JsonProperty("url")
    protected String url;

    protected PlannerPlanContainer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.plannerPlanContainer";
    }

    @Property(name="containerId")
    @JsonIgnore
    public Optional<String> getContainerId() {
        return Optional.ofNullable(containerId);
    }

    public PlannerPlanContainer withContainerId(String containerId) {
        PlannerPlanContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContainer");
        _x.containerId = containerId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<PlannerContainerType> getType() {
        return Optional.ofNullable(type);
    }

    public PlannerPlanContainer withType(PlannerContainerType type) {
        PlannerPlanContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContainer");
        _x.type = type;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public PlannerPlanContainer withUrl(String url) {
        PlannerPlanContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.plannerPlanContainer");
        _x.url = url;
        return _x;
    }

    public PlannerPlanContainer withUnmappedField(String name, Object value) {
        PlannerPlanContainer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String containerId;
        private PlannerContainerType type;
        private String url;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder containerId(String containerId) {
            this.containerId = containerId;
            this.changedFields = changedFields.add("containerId");
            return this;
        }

        public Builder type(PlannerContainerType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public PlannerPlanContainer build() {
            PlannerPlanContainer _x = new PlannerPlanContainer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.plannerPlanContainer";
            _x.containerId = containerId;
            _x.type = type;
            _x.url = url;
            return _x;
        }
    }

    private PlannerPlanContainer _copy() {
        PlannerPlanContainer _x = new PlannerPlanContainer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.containerId = containerId;
        _x.type = type;
        _x.url = url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PlannerPlanContainer[");
        b.append("containerId=");
        b.append(this.containerId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
