package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isActive", 
    "notAfter", 
    "notBefore", 
    "thumbprint"})
@JsonInclude(Include.NON_NULL)
public class Pkcs12CertificateInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("notAfter")
    protected Long notAfter;

    @JsonProperty("notBefore")
    protected Long notBefore;

    @JsonProperty("thumbprint")
    protected String thumbprint;

    protected Pkcs12CertificateInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.pkcs12CertificateInformation";
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public Pkcs12CertificateInformation withIsActive(Boolean isActive) {
        Pkcs12CertificateInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pkcs12CertificateInformation");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="notAfter")
    @JsonIgnore
    public Optional<Long> getNotAfter() {
        return Optional.ofNullable(notAfter);
    }

    public Pkcs12CertificateInformation withNotAfter(Long notAfter) {
        Pkcs12CertificateInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pkcs12CertificateInformation");
        _x.notAfter = notAfter;
        return _x;
    }

    @Property(name="notBefore")
    @JsonIgnore
    public Optional<Long> getNotBefore() {
        return Optional.ofNullable(notBefore);
    }

    public Pkcs12CertificateInformation withNotBefore(Long notBefore) {
        Pkcs12CertificateInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pkcs12CertificateInformation");
        _x.notBefore = notBefore;
        return _x;
    }

    @Property(name="thumbprint")
    @JsonIgnore
    public Optional<String> getThumbprint() {
        return Optional.ofNullable(thumbprint);
    }

    public Pkcs12CertificateInformation withThumbprint(String thumbprint) {
        Pkcs12CertificateInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.pkcs12CertificateInformation");
        _x.thumbprint = thumbprint;
        return _x;
    }

    public Pkcs12CertificateInformation withUnmappedField(String name, Object value) {
        Pkcs12CertificateInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isActive;
        private Long notAfter;
        private Long notBefore;
        private String thumbprint;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder notAfter(Long notAfter) {
            this.notAfter = notAfter;
            this.changedFields = changedFields.add("notAfter");
            return this;
        }

        public Builder notBefore(Long notBefore) {
            this.notBefore = notBefore;
            this.changedFields = changedFields.add("notBefore");
            return this;
        }

        public Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            this.changedFields = changedFields.add("thumbprint");
            return this;
        }

        public Pkcs12CertificateInformation build() {
            Pkcs12CertificateInformation _x = new Pkcs12CertificateInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.pkcs12CertificateInformation";
            _x.isActive = isActive;
            _x.notAfter = notAfter;
            _x.notBefore = notBefore;
            _x.thumbprint = thumbprint;
            return _x;
        }
    }

    private Pkcs12CertificateInformation _copy() {
        Pkcs12CertificateInformation _x = new Pkcs12CertificateInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isActive = isActive;
        _x.notAfter = notAfter;
        _x.notBefore = notBefore;
        _x.thumbprint = thumbprint;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Pkcs12CertificateInformation[");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("notAfter=");
        b.append(this.notAfter);
        b.append(", ");
        b.append("notBefore=");
        b.append(this.notBefore);
        b.append(", ");
        b.append("thumbprint=");
        b.append(this.thumbprint);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
