package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "city", 
    "countryOrRegion", 
    "officeLocation", 
    "postalCode", 
    "state", 
    "street"})
@JsonInclude(Include.NON_NULL)
public class PhysicalOfficeAddress implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("countryOrRegion")
    protected String countryOrRegion;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("postalCode")
    protected String postalCode;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("street")
    protected String street;

    protected PhysicalOfficeAddress() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.physicalOfficeAddress";
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public PhysicalOfficeAddress withCity(String city) {
        PhysicalOfficeAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalOfficeAddress");
        _x.city = city;
        return _x;
    }

    @Property(name="countryOrRegion")
    @JsonIgnore
    public Optional<String> getCountryOrRegion() {
        return Optional.ofNullable(countryOrRegion);
    }

    public PhysicalOfficeAddress withCountryOrRegion(String countryOrRegion) {
        PhysicalOfficeAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalOfficeAddress");
        _x.countryOrRegion = countryOrRegion;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public PhysicalOfficeAddress withOfficeLocation(String officeLocation) {
        PhysicalOfficeAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalOfficeAddress");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="postalCode")
    @JsonIgnore
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(postalCode);
    }

    public PhysicalOfficeAddress withPostalCode(String postalCode) {
        PhysicalOfficeAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalOfficeAddress");
        _x.postalCode = postalCode;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public PhysicalOfficeAddress withState(String state) {
        PhysicalOfficeAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalOfficeAddress");
        _x.state = state;
        return _x;
    }

    @Property(name="street")
    @JsonIgnore
    public Optional<String> getStreet() {
        return Optional.ofNullable(street);
    }

    public PhysicalOfficeAddress withStreet(String street) {
        PhysicalOfficeAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.physicalOfficeAddress");
        _x.street = street;
        return _x;
    }

    public PhysicalOfficeAddress withUnmappedField(String name, Object value) {
        PhysicalOfficeAddress _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String city;
        private String countryOrRegion;
        private String officeLocation;
        private String postalCode;
        private String state;
        private String street;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder countryOrRegion(String countryOrRegion) {
            this.countryOrRegion = countryOrRegion;
            this.changedFields = changedFields.add("countryOrRegion");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.changedFields = changedFields.add("postalCode");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            this.changedFields = changedFields.add("street");
            return this;
        }

        public PhysicalOfficeAddress build() {
            PhysicalOfficeAddress _x = new PhysicalOfficeAddress();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.physicalOfficeAddress";
            _x.city = city;
            _x.countryOrRegion = countryOrRegion;
            _x.officeLocation = officeLocation;
            _x.postalCode = postalCode;
            _x.state = state;
            _x.street = street;
            return _x;
        }
    }

    private PhysicalOfficeAddress _copy() {
        PhysicalOfficeAddress _x = new PhysicalOfficeAddress();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.city = city;
        _x.countryOrRegion = countryOrRegion;
        _x.officeLocation = officeLocation;
        _x.postalCode = postalCode;
        _x.state = state;
        _x.street = street;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PhysicalOfficeAddress[");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("countryOrRegion=");
        b.append(this.countryOrRegion);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("postalCode=");
        b.append(this.postalCode);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("street=");
        b.append(this.street);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
