package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "cameraMake", 
    "cameraModel", 
    "exposureDenominator", 
    "exposureNumerator", 
    "fNumber", 
    "focalLength", 
    "iso", 
    "orientation", 
    "takenDateTime"})
@JsonInclude(Include.NON_NULL)
public class Photo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("cameraMake")
    protected String cameraMake;

    @JsonProperty("cameraModel")
    protected String cameraModel;

    @JsonProperty("exposureDenominator")
    protected Double exposureDenominator;

    @JsonProperty("exposureNumerator")
    protected Double exposureNumerator;

    @JsonProperty("fNumber")
    protected Double fNumber;

    @JsonProperty("focalLength")
    protected Double focalLength;

    @JsonProperty("iso")
    protected Integer iso;

    @JsonProperty("orientation")
    protected Short orientation;

    @JsonProperty("takenDateTime")
    protected OffsetDateTime takenDateTime;

    protected Photo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.photo";
    }

    @Property(name="cameraMake")
    @JsonIgnore
    public Optional<String> getCameraMake() {
        return Optional.ofNullable(cameraMake);
    }

    public Photo withCameraMake(String cameraMake) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.cameraMake = cameraMake;
        return _x;
    }

    @Property(name="cameraModel")
    @JsonIgnore
    public Optional<String> getCameraModel() {
        return Optional.ofNullable(cameraModel);
    }

    public Photo withCameraModel(String cameraModel) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.cameraModel = cameraModel;
        return _x;
    }

    @Property(name="exposureDenominator")
    @JsonIgnore
    public Optional<Double> getExposureDenominator() {
        return Optional.ofNullable(exposureDenominator);
    }

    public Photo withExposureDenominator(Double exposureDenominator) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.exposureDenominator = exposureDenominator;
        return _x;
    }

    @Property(name="exposureNumerator")
    @JsonIgnore
    public Optional<Double> getExposureNumerator() {
        return Optional.ofNullable(exposureNumerator);
    }

    public Photo withExposureNumerator(Double exposureNumerator) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.exposureNumerator = exposureNumerator;
        return _x;
    }

    @Property(name="fNumber")
    @JsonIgnore
    public Optional<Double> getFNumber() {
        return Optional.ofNullable(fNumber);
    }

    public Photo withFNumber(Double fNumber) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.fNumber = fNumber;
        return _x;
    }

    @Property(name="focalLength")
    @JsonIgnore
    public Optional<Double> getFocalLength() {
        return Optional.ofNullable(focalLength);
    }

    public Photo withFocalLength(Double focalLength) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.focalLength = focalLength;
        return _x;
    }

    @Property(name="iso")
    @JsonIgnore
    public Optional<Integer> getIso() {
        return Optional.ofNullable(iso);
    }

    public Photo withIso(Integer iso) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.iso = iso;
        return _x;
    }

    @Property(name="orientation")
    @JsonIgnore
    public Optional<Short> getOrientation() {
        return Optional.ofNullable(orientation);
    }

    public Photo withOrientation(Short orientation) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.orientation = orientation;
        return _x;
    }

    @Property(name="takenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getTakenDateTime() {
        return Optional.ofNullable(takenDateTime);
    }

    public Photo withTakenDateTime(OffsetDateTime takenDateTime) {
        Photo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.photo");
        _x.takenDateTime = takenDateTime;
        return _x;
    }

    public Photo withUnmappedField(String name, Object value) {
        Photo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String cameraMake;
        private String cameraModel;
        private Double exposureDenominator;
        private Double exposureNumerator;
        private Double fNumber;
        private Double focalLength;
        private Integer iso;
        private Short orientation;
        private OffsetDateTime takenDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder cameraMake(String cameraMake) {
            this.cameraMake = cameraMake;
            this.changedFields = changedFields.add("cameraMake");
            return this;
        }

        public Builder cameraModel(String cameraModel) {
            this.cameraModel = cameraModel;
            this.changedFields = changedFields.add("cameraModel");
            return this;
        }

        public Builder exposureDenominator(Double exposureDenominator) {
            this.exposureDenominator = exposureDenominator;
            this.changedFields = changedFields.add("exposureDenominator");
            return this;
        }

        public Builder exposureNumerator(Double exposureNumerator) {
            this.exposureNumerator = exposureNumerator;
            this.changedFields = changedFields.add("exposureNumerator");
            return this;
        }

        public Builder fNumber(Double fNumber) {
            this.fNumber = fNumber;
            this.changedFields = changedFields.add("fNumber");
            return this;
        }

        public Builder focalLength(Double focalLength) {
            this.focalLength = focalLength;
            this.changedFields = changedFields.add("focalLength");
            return this;
        }

        public Builder iso(Integer iso) {
            this.iso = iso;
            this.changedFields = changedFields.add("iso");
            return this;
        }

        public Builder orientation(Short orientation) {
            this.orientation = orientation;
            this.changedFields = changedFields.add("orientation");
            return this;
        }

        public Builder takenDateTime(OffsetDateTime takenDateTime) {
            this.takenDateTime = takenDateTime;
            this.changedFields = changedFields.add("takenDateTime");
            return this;
        }

        public Photo build() {
            Photo _x = new Photo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.photo";
            _x.cameraMake = cameraMake;
            _x.cameraModel = cameraModel;
            _x.exposureDenominator = exposureDenominator;
            _x.exposureNumerator = exposureNumerator;
            _x.fNumber = fNumber;
            _x.focalLength = focalLength;
            _x.iso = iso;
            _x.orientation = orientation;
            _x.takenDateTime = takenDateTime;
            return _x;
        }
    }

    private Photo _copy() {
        Photo _x = new Photo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.cameraMake = cameraMake;
        _x.cameraModel = cameraModel;
        _x.exposureDenominator = exposureDenominator;
        _x.exposureNumerator = exposureNumerator;
        _x.fNumber = fNumber;
        _x.focalLength = focalLength;
        _x.iso = iso;
        _x.orientation = orientation;
        _x.takenDateTime = takenDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Photo[");
        b.append("cameraMake=");
        b.append(this.cameraMake);
        b.append(", ");
        b.append("cameraModel=");
        b.append(this.cameraModel);
        b.append(", ");
        b.append("exposureDenominator=");
        b.append(this.exposureDenominator);
        b.append(", ");
        b.append("exposureNumerator=");
        b.append(this.exposureNumerator);
        b.append(", ");
        b.append("fNumber=");
        b.append(this.fNumber);
        b.append(", ");
        b.append("focalLength=");
        b.append(this.focalLength);
        b.append(", ");
        b.append("iso=");
        b.append(this.iso);
        b.append(", ");
        b.append("orientation=");
        b.append(this.orientation);
        b.append(", ");
        b.append("takenDateTime=");
        b.append(this.takenDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
