package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "rawContent", 
    "visualContent"})
@JsonInclude(Include.NON_NULL)
public class PayloadTypes implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("rawContent")
    protected String rawContent;

    @JsonProperty("visualContent")
    protected VisualProperties visualContent;

    protected PayloadTypes() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.payloadTypes";
    }

    @Property(name="rawContent")
    @JsonIgnore
    public Optional<String> getRawContent() {
        return Optional.ofNullable(rawContent);
    }

    public PayloadTypes withRawContent(String rawContent) {
        PayloadTypes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.payloadTypes");
        _x.rawContent = rawContent;
        return _x;
    }

    @Property(name="visualContent")
    @JsonIgnore
    public Optional<VisualProperties> getVisualContent() {
        return Optional.ofNullable(visualContent);
    }

    public PayloadTypes withVisualContent(VisualProperties visualContent) {
        PayloadTypes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.payloadTypes");
        _x.visualContent = visualContent;
        return _x;
    }

    public PayloadTypes withUnmappedField(String name, Object value) {
        PayloadTypes _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String rawContent;
        private VisualProperties visualContent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            this.changedFields = changedFields.add("rawContent");
            return this;
        }

        public Builder visualContent(VisualProperties visualContent) {
            this.visualContent = visualContent;
            this.changedFields = changedFields.add("visualContent");
            return this;
        }

        public PayloadTypes build() {
            PayloadTypes _x = new PayloadTypes();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.payloadTypes";
            _x.rawContent = rawContent;
            _x.visualContent = visualContent;
            return _x;
        }
    }

    private PayloadTypes _copy() {
        PayloadTypes _x = new PayloadTypes();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.rawContent = rawContent;
        _x.visualContent = visualContent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PayloadTypes[");
        b.append("rawContent=");
        b.append(this.rawContent);
        b.append(", ");
        b.append("visualContent=");
        b.append(this.visualContent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
