package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isValid", 
    "validationResults"})
@JsonInclude(Include.NON_NULL)
public class PasswordValidationInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isValid")
    protected Boolean isValid;

    @JsonProperty("validationResults")
    protected List<ValidationResult> validationResults;

    @JsonProperty("validationResults@nextLink")
    protected String validationResultsNextLink;

    protected PasswordValidationInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordValidationInformation";
    }

    @Property(name="isValid")
    @JsonIgnore
    public Optional<Boolean> getIsValid() {
        return Optional.ofNullable(isValid);
    }

    public PasswordValidationInformation withIsValid(Boolean isValid) {
        PasswordValidationInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordValidationInformation");
        _x.isValid = isValid;
        return _x;
    }

    @Property(name="validationResults")
    @JsonIgnore
    public CollectionPage<ValidationResult> getValidationResults() {
        return new CollectionPage<ValidationResult>(contextPath, ValidationResult.class, this.validationResults, Optional.ofNullable(validationResultsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="validationResults")
    @JsonIgnore
    public CollectionPage<ValidationResult> getValidationResults(HttpRequestOptions options) {
        return new CollectionPage<ValidationResult>(contextPath, ValidationResult.class, this.validationResults, Optional.ofNullable(validationResultsNextLink), Collections.emptyList(), options);
    }

    public PasswordValidationInformation withUnmappedField(String name, Object value) {
        PasswordValidationInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isValid;
        private List<ValidationResult> validationResults;
        private String validationResultsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            this.changedFields = changedFields.add("isValid");
            return this;
        }

        public Builder validationResults(List<ValidationResult> validationResults) {
            this.validationResults = validationResults;
            this.changedFields = changedFields.add("validationResults");
            return this;
        }

        public Builder validationResults(ValidationResult... validationResults) {
            return validationResults(Arrays.asList(validationResults));
        }

        public Builder validationResultsNextLink(String validationResultsNextLink) {
            this.validationResultsNextLink = validationResultsNextLink;
            this.changedFields = changedFields.add("validationResults");
            return this;
        }

        public PasswordValidationInformation build() {
            PasswordValidationInformation _x = new PasswordValidationInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.passwordValidationInformation";
            _x.isValid = isValid;
            _x.validationResults = validationResults;
            _x.validationResultsNextLink = validationResultsNextLink;
            return _x;
        }
    }

    private PasswordValidationInformation _copy() {
        PasswordValidationInformation _x = new PasswordValidationInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isValid = isValid;
        _x.validationResults = validationResults;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordValidationInformation[");
        b.append("isValid=");
        b.append(this.isValid);
        b.append(", ");
        b.append("validationResults=");
        b.append(this.validationResults);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
