package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "customizedLabel", 
    "defaultLabel", 
    "fieldId", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class PasswordSingleSignOnField implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("customizedLabel")
    protected String customizedLabel;

    @JsonProperty("defaultLabel")
    protected String defaultLabel;

    @JsonProperty("fieldId")
    protected String fieldId;

    @JsonProperty("type")
    protected String type;

    protected PasswordSingleSignOnField() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordSingleSignOnField";
    }

    @Property(name="customizedLabel")
    @JsonIgnore
    public Optional<String> getCustomizedLabel() {
        return Optional.ofNullable(customizedLabel);
    }

    public PasswordSingleSignOnField withCustomizedLabel(String customizedLabel) {
        PasswordSingleSignOnField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordSingleSignOnField");
        _x.customizedLabel = customizedLabel;
        return _x;
    }

    @Property(name="defaultLabel")
    @JsonIgnore
    public Optional<String> getDefaultLabel() {
        return Optional.ofNullable(defaultLabel);
    }

    public PasswordSingleSignOnField withDefaultLabel(String defaultLabel) {
        PasswordSingleSignOnField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordSingleSignOnField");
        _x.defaultLabel = defaultLabel;
        return _x;
    }

    @Property(name="fieldId")
    @JsonIgnore
    public Optional<String> getFieldId() {
        return Optional.ofNullable(fieldId);
    }

    public PasswordSingleSignOnField withFieldId(String fieldId) {
        PasswordSingleSignOnField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordSingleSignOnField");
        _x.fieldId = fieldId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public PasswordSingleSignOnField withType(String type) {
        PasswordSingleSignOnField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordSingleSignOnField");
        _x.type = type;
        return _x;
    }

    public PasswordSingleSignOnField withUnmappedField(String name, Object value) {
        PasswordSingleSignOnField _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String customizedLabel;
        private String defaultLabel;
        private String fieldId;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder customizedLabel(String customizedLabel) {
            this.customizedLabel = customizedLabel;
            this.changedFields = changedFields.add("customizedLabel");
            return this;
        }

        public Builder defaultLabel(String defaultLabel) {
            this.defaultLabel = defaultLabel;
            this.changedFields = changedFields.add("defaultLabel");
            return this;
        }

        public Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            this.changedFields = changedFields.add("fieldId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public PasswordSingleSignOnField build() {
            PasswordSingleSignOnField _x = new PasswordSingleSignOnField();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.passwordSingleSignOnField";
            _x.customizedLabel = customizedLabel;
            _x.defaultLabel = defaultLabel;
            _x.fieldId = fieldId;
            _x.type = type;
            return _x;
        }
    }

    private PasswordSingleSignOnField _copy() {
        PasswordSingleSignOnField _x = new PasswordSingleSignOnField();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.customizedLabel = customizedLabel;
        _x.defaultLabel = defaultLabel;
        _x.fieldId = fieldId;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordSingleSignOnField[");
        b.append("customizedLabel=");
        b.append(this.customizedLabel);
        b.append(", ");
        b.append("defaultLabel=");
        b.append(this.defaultLabel);
        b.append(", ");
        b.append("fieldId=");
        b.append(this.fieldId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
